/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import nl.strohalm.cyclos.taglibs.AbstractDynamicAttributesTag;

public class CustomImageUrlTag
extends AbstractDynamicAttributesTag {
    private static final long serialVersionUID = -7999583664245494008L;
    private static final String DEFAULT_TYPE = "custom";
    private String name;
    private String type = "custom";
    private boolean thumbnail;

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.print(this.resolveUrl());
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isThumbnail() {
        return this.thumbnail;
    }

    @Override
    public void release() {
        super.release();
        this.name = null;
        this.type = DEFAULT_TYPE;
        this.thumbnail = false;
    }

    public void setName(String image) {
        this.name = image;
    }

    public void setThumbnail(boolean thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected String resolveUrl() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append(request.getContextPath()).append(this.path()).append("?image=").append(this.name);
        if (this.thumbnail) {
            sb.append("&thumbnail=true");
        }
        return sb.toString();
    }

    private String path() {
        return "/" + this.type + "Image";
    }
}

