/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.conversion.AmountConverter;
import nl.strohalm.cyclos.utils.conversion.CardNumberConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FormatTag
extends TagSupport {
    private static final long serialVersionUID = 5262848042770106863L;
    private Amount amount;
    private Calendar rawDate;
    private Calendar date;
    private Calendar dateTime;
    private Calendar time;
    private Number number;
    private Long bytes;
    private Object defaultValue;
    private Integer precision;
    private boolean forceSignal;
    private String unitsPattern;
    private String cardNumberPattern;

    public int doEndTag() throws JspException {
        String out = "";
        LocalSettings localSettings = this.getLocalSettings();
        if (this.number != null) {
            if (this.number instanceof Double || this.number instanceof BigDecimal || this.number instanceof Float) {
                BigDecimal theNumber = CoercionHelper.coerce(BigDecimal.class, this.number);
                NumberConverter numberConverter = StringUtils.isNotEmpty((String)this.unitsPattern) ? localSettings.getUnitsConverter(this.unitsPattern) : (this.precision == null ? localSettings.getNumberConverter() : localSettings.getNumberConverterForPrecision(this.precision));
                out = numberConverter.toString(theNumber);
                if (this.forceSignal && theNumber.compareTo(BigDecimal.ZERO) > 0) {
                    out = "+" + out;
                }
            } else if (this.number instanceof StatisticalNumber) {
                out = this.convertStatisticalNumber((StatisticalNumber)this.number);
            } else if (this.number instanceof BigInteger && this.cardNumberPattern != null) {
                out = new CardNumberConverter(this.cardNumberPattern).toString((BigInteger)this.number);
            } else {
                NumberConverter<Long> longConverter = localSettings.getLongConverter();
                Long theNumber = CoercionHelper.coerce(Long.class, this.number);
                out = longConverter.toString(theNumber);
            }
        } else if (this.amount != null) {
            AmountConverter converter = StringUtils.isEmpty((String)this.unitsPattern) ? localSettings.getAmountConverter() : localSettings.getAmountConverter(this.unitsPattern);
            out = converter.toString(this.amount);
        } else {
            out = this.rawDate != null ? localSettings.getRawDateConverter().toString(this.rawDate) : (this.date != null ? localSettings.getDateConverter().toString(this.date) : (this.dateTime != null ? localSettings.getDateTimeConverter().toString(this.dateTime) : (this.time != null ? localSettings.getTimeConverter().toString(this.time) : (this.bytes != null ? FileUtils.byteCountToDisplaySize((long)this.bytes) : (this.defaultValue == null ? null : this.defaultValue.toString())))));
        }
        try {
            if (StringUtils.isNotEmpty((String)out)) {
                this.pageContext.getOut().print(out);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
        return 6;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Long getBytes() {
        return this.bytes;
    }

    public String getCardNumberPattern() {
        return this.cardNumberPattern;
    }

    public Calendar getDate() {
        return this.date;
    }

    public Calendar getDateTime() {
        return this.dateTime;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object getNumber() {
        return this.number;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Calendar getTime() {
        return this.time;
    }

    public String getUnitsPattern() {
        return this.unitsPattern;
    }

    public boolean isForceSignal() {
        return this.forceSignal;
    }

    public void release() {
        super.release();
        this.number = null;
        this.amount = null;
        this.rawDate = null;
        this.date = null;
        this.dateTime = null;
        this.time = null;
        this.bytes = null;
        this.defaultValue = null;
        this.precision = null;
        this.forceSignal = false;
        this.cardNumberPattern = null;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public void setCardNumberPattern(String cardNumberPattern) {
        this.cardNumberPattern = cardNumberPattern;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDateTime(Calendar dateTime) {
        this.dateTime = dateTime;
    }

    public void setDefault(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setForceSignal(boolean forceSignal) {
        this.forceSignal = forceSignal;
    }

    public void setNumber(Object number) {
        this.number = CoercionHelper.coerce(Number.class, number);
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setRawDate(Calendar rawDate) {
        this.rawDate = rawDate;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public void setUnitsPattern(String unitsPattern) {
        this.unitsPattern = unitsPattern;
    }

    private String convertStatisticalNumber(StatisticalNumber number) {
        Integer lPrecision = this.precision == null ? new Integer(number.getPrecision()) : this.precision;
        NumberConverter<BigDecimal> numberConverter = this.getLocalSettings().getNumberConverterForPrecision(lPrecision);
        if (number.isNull()) {
            return "-";
        }
        String data = numberConverter.toString(new BigDecimal(number.floatValue()));
        if (number.isPercentage()) {
            data = data + "%";
        } else if (number.isPvalue() && (double)number.floatValue() < 0.05) {
            data = "<b>" + data + "</b>";
        } else if (number.hasErrorBar()) {
            if (number.hasSymmetricalErrorBar()) {
                String error = numberConverter.toString(new BigDecimal(number.getError().floatValue()));
                data = data + "&nbsp;&#177;&nbsp;" + error;
            } else {
                String lower = numberConverter.toString(new BigDecimal(number.getLowerBound().floatValue()));
                String upper = numberConverter.toString(new BigDecimal(number.getUpperBound().floatValue()));
                data = data + "&nbsp;&nbsp;(" + lower + " - " + upper + ")";
            }
        }
        return data;
    }

    private LocalSettings getLocalSettings() {
        SettingsService settingsService = SpringHelper.bean(this.pageContext.getServletContext(), SettingsService.class);
        LocalSettings settings = settingsService.getLocalSettings();
        return settings;
    }
}

