/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class Functions {
    public static boolean contains(Object collection, Object value) {
        if (collection == null) {
            return false;
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).contains(value);
        }
        if (collection instanceof Map) {
            return ((Map)collection).containsKey(value);
        }
        if (collection.getClass().isArray()) {
            return Arrays.asList((Object[])collection).contains(value);
        }
        throw new IllegalArgumentException("Can't determine if " + collection + " contains " + value);
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static boolean granted(Permission permission) {
        try {
            ApplicationContext context = (ApplicationContext)LoggedUser.getAttribute("applicationContext");
            PermissionService permissionService = SpringHelper.bean((BeanFactory)context, PermissionService.class);
            return permissionService.hasPermission(permission);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String name(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }

    public static BigDecimal round(Object object) {
        try {
            Number number = CoercionHelper.coerce(BigDecimal.class, object);
            ApplicationContext context = (ApplicationContext)LoggedUser.getAttribute("applicationContext");
            SettingsService settingsService = SpringHelper.bean((BeanFactory)context, SettingsService.class);
            LocalSettings localSettings = settingsService.getLocalSettings();
            return localSettings.round(CoercionHelper.coerce(BigDecimal.class, number));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object value(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof StringValuedEnum) {
            return ((StringValuedEnum)object).getValue();
        }
        if (object instanceof IntValuedEnum) {
            return ((IntValuedEnum)object).getValue();
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }
}

