/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ImagesTag
extends TagSupport {
    private static final long serialVersionUID = -2838185736271052294L;
    private boolean editable;
    private List<? extends OwneredImage> images;
    private boolean imageOnly;
    private String varName;
    private String style;

    public int doEndTag() throws JspException {
        this.release();
        return super.doEndTag();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        StringBuilder sb = new StringBuilder();
        if (this.images == null) {
            this.images = Collections.emptyList();
        }
        LocalSettings localSettings = this.getLocalSettings();
        Image.Nature nature = null;
        Long ownerId = null;
        if (!this.images.isEmpty()) {
            OwneredImage image = this.images.iterator().next();
            nature = image.getNature();
            ownerId = image.getOwner().getId();
        }
        int adjust = this.imageOnly ? 0 : 8;
        int width = localSettings.getMaxThumbnailWidth() + adjust;
        String rnd = System.currentTimeMillis() + "_" + RandomStringUtils.random((int)4, (boolean)true, (boolean)false);
        String id = "img_" + rnd;
        sb.append("<div id='").append(id).append("' style='width:").append(width).append("px;").append(this.style == null ? "" : this.style).append("' class='imageContainerDiv ").append(this.imageOnly ? "" : "imageContainer").append("'>");
        if (!this.imageOnly) {
            sb.append("<div class='thumbnailContainer'><table style='width:100%;border:none;padding:0px;margin:0px;'><tr><td style='text-align:center;vertical-align:middle;border:none;padding:0px;margin:0px;'>\n");
        }
        sb.append("<img class='thumbnail' id='thumbnail_").append(rnd).append("' src='").append(request.getContextPath()).append("/systemImage?image=noPicture&thumbnail=true'/>");
        if (!this.imageOnly) {
            sb.append("</td></tr></table></div>");
            if (this.images.size() > 1) {
                sb.append("<div class='imageControls' id='imageControls_").append(rnd).append("'><table cellpadding='0' cellspacing='0' border='0' width='100%'><tr>");
                sb.append("<td style='padding:0px' class='imageControlPrevious' id='previous_").append(rnd).append("' onclick='this.container.previousImage()' align='center' width='10'><img style='cursor:pointer;cursor:hand;' src=\"" + request.getContextPath() + "/pages/images/previous.gif\" border=\"0\"></td>");
                sb.append("<td style='padding:0px' class='imageIndex' id='index_").append(rnd).append("' nowrap='nowrap' align='center'>1 / ").append(this.images.size()).append("</td>");
                sb.append("<td style='padding:0px' class='imageControlNext' id='next_").append(rnd).append("' onclick='this.container.nextImage()' align='center' width='10'><img style='cursor:pointer;cursor:hand;' src=\"" + request.getContextPath() + "/pages/images/next.gif\" border=\"0\"></td>");
                sb.append("</tr></table></div>\n");
            }
            if (this.editable && !this.images.isEmpty()) {
                MessageHelper messageHelper = SpringHelper.bean(this.pageContext.getServletContext(), MessageHelper.class);
                sb.append("<div class='imageDetails' id='imageDetails_").append(rnd).append("' style='cursor:pointer;cursor:hand' onclick='this.container.details()'><a>");
                sb.append(messageHelper.message("image.details", new Object[0]));
                sb.append("</a></div>\n");
                sb.append("<div class='imageRemove' id='imageRemove_").append(rnd).append("' style='cursor:pointer;cursor:hand' onclick='this.container.removeImage()'><a>");
                sb.append(messageHelper.message("image.remove", new Object[0]));
                sb.append("</a></div>\n");
            }
        }
        sb.append("</div>\n");
        sb.append("<script>\n");
        String varName = StringUtils.isEmpty((String)this.varName) ? id : this.varName;
        sb.append(String.format("var %s = new ImageContainer($('%s'), '%s', '%s');\n", varName, id, nature, ownerId));
        for (OwneredImage owneredImage : this.images) {
            String caption = StringEscapeUtils.escapeHtml((String)StringUtils.trimToEmpty((String)owneredImage.getCaption()));
            String url = StringEscapeUtils.escapeHtml((String)(request.getContextPath() + "/thumbnail?id=" + owneredImage.getId()));
            sb.append(varName).append(String.format(".imageDescriptors.push(new ImageDescriptor('%s', '%s', '%s'));\n", owneredImage.getId(), StringEscapeUtils.escapeJavaScript((String)caption), StringEscapeUtils.escapeJavaScript((String)url)));
        }
        sb.append(varName).append(".appendElement('index', 'index_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('thumbnail', 'thumbnail_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('controls', 'imageControls_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('previous', 'previous_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('next', 'next_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('imageRemove', 'imageRemove_").append(rnd).append("');\n");
        sb.append(varName).append(".appendElement('imageDetails', 'imageDetails_").append(rnd).append("');\n");
        sb.append(varName).append(".currentImage = 0;\n");
        sb.append(varName).append(".updateImage();\n");
        sb.append("</script>\n");
        try {
            this.pageContext.getOut().print(sb.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public List<? extends OwneredImage> getImages() {
        return this.images;
    }

    public String getVarName() {
        return this.varName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isImageOnly() {
        return this.imageOnly;
    }

    public void release() {
        super.release();
        this.images = null;
        this.varName = null;
        this.imageOnly = false;
        this.editable = false;
        this.style = null;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setImageOnly(boolean imageOnly) {
        this.imageOnly = imageOnly;
    }

    public void setImages(List<? extends OwneredImage> images) {
        this.images = images;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    private LocalSettings getLocalSettings() {
        SettingsService settingsService = SpringHelper.bean(this.pageContext.getServletContext(), SettingsService.class);
        LocalSettings settings = settingsService.getLocalSettings();
        return settings;
    }
}

