/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.taglibs.EscapeHTMLTag;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MenuTag
extends TagSupport {
    private static final long serialVersionUID = 1447606721801461983L;
    private String confirmationKey;
    private String key;
    private String url;
    private Module module;
    private Permission permission;
    private String label;
    private PermissionService permissionService;
    private Menu menu;
    private MessageHelper messageHelper;

    public int doEndTag() throws JspException {
        try {
            if (this.menu == null || this.menu.isNested() || !this.menu.hasContent()) {
                int n = 6;
                return n;
            }
            JspWriter out = this.pageContext.getOut();
            int index = this.index();
            String divId = this.divId(this.menu, index);
            this.renderDiv(this.menu, index, divId);
            List<Menu> subMenus = this.menu.getChildren();
            if (CollectionUtils.isNotEmpty(subMenus)) {
                out.print("<ul id='subMenuContainer" + index + "' class='subMenuContainer' style='display:none'>");
                int subMenuCount = subMenus.size();
                for (int i = 0; i < subMenuCount; ++i) {
                    Menu subMenu = subMenus.get(i);
                    String subMenuId = this.divId(subMenu, i);
                    this.renderDiv(subMenu, i, subMenuId);
                    if (i == 0) {
                        out.println("<script>$('" + subMenuId + "').addClassName('firstSubMenu');</script>");
                        continue;
                    }
                    if (i != subMenuCount - 1) continue;
                    out.println("<script>$('" + subMenuId + "').addClassName('lastSubMenu');</script>");
                }
                out.println("</ul></li>");
            }
            out.println();
            out.println("<script>allMenus.push($('" + divId + "'));</script>");
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public int doStartTag() throws JspException {
        boolean granted = true;
        if (this.permission != null) {
            granted = this.permissionService.hasPermission(this.permission);
        } else if (this.module != null) {
            granted = this.permissionService.hasPermission(this.module);
        }
        if (!granted) {
            return 6;
        }
        if (StringUtils.isEmpty((String)this.label) && StringUtils.isNotEmpty((String)this.key)) {
            this.label = this.messageHelper.message(this.key, new Object[0]);
        }
        this.menu = new Menu(this.label, this.url, this.confirmationKey);
        MenuTag parentTag = (MenuTag)MenuTag.findAncestorWithClass((Tag)this, MenuTag.class);
        if (parentTag != null) {
            Menu parentMenu = parentTag.getMenu();
            if (parentMenu != null) {
                parentMenu.addChild(this.menu);
            } else {
                this.menu = null;
            }
        }
        return 1;
    }

    public String getConfirmationKey() {
        return this.confirmationKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Module getModule() {
        return this.module;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getUrl() {
        return this.url;
    }

    public void release() {
        this.label = null;
        this.key = null;
        this.url = null;
        this.module = null;
        this.permission = null;
        this.confirmationKey = null;
        this.menu = null;
        super.release();
    }

    public void setConfirmationKey(String confirmationKey) {
        this.confirmationKey = confirmationKey;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setLabel(String displayName) {
        this.label = displayName;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.permissionService = SpringHelper.bean(pageContext.getServletContext(), PermissionService.class);
        this.messageHelper = SpringHelper.bean(pageContext.getServletContext(), MessageHelper.class);
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private String divId(Menu menu, int index) {
        if (menu.isNested()) {
            return "submenu" + this.pageContext.getAttribute("menuIndex") + "." + index;
        }
        return "menu" + index;
    }

    private String getClassName(Menu menu) {
        return menu.isNested() ? "subMenu" : "menu";
    }

    private int index() {
        int index = (Integer)ObjectUtils.defaultIfNull((Object)this.pageContext.getAttribute("menuIndex"), (Object)-1);
        this.pageContext.setAttribute("menuIndex", (Object)(++index));
        return index;
    }

    private void renderDiv(Menu menu, int index, String divId) throws IOException, JspException {
        JspWriter out = this.pageContext.getOut();
        String className = this.getClassName(menu);
        out.print("<li id='" + divId + "'class='" + className + "'");
        String url = menu.getUrl();
        if (StringUtils.isNotEmpty((String)url)) {
            url = (url = StringEscapeUtils.escapeHtml((String)url)).contains("?") ? url + "&" : url + "?";
            url = url + "fromMenu=true";
            out.print(" linkURL=\"" + url + "\"");
            String confirmationKey = menu.getConfirmationKey();
            if (StringUtils.isNotEmpty((String)confirmationKey)) {
                out.print(" confirmationMessage=\"" + StringEscapeUtils.escapeHtml((String)this.messageHelper.message(confirmationKey, new Object[0])) + "\"");
            }
        }
        out.print(">");
        out.print("<span class=\"" + className + "Bullet\"></span>");
        out.print("<span class=\"" + className + "Text\">");
        String displayName = menu.getLabel();
        out.print(EscapeHTMLTag.escape(displayName, true));
        out.println("</span>");
        if (menu.getParent() == null) {
            out.println("<script>menuCount++;</script>");
        }
    }

    private static class Menu {
        private final String url;
        private final String label;
        private final String confirmationKey;
        private Menu parent;
        private List<Menu> children;

        public Menu(String label, String url, String confirmationKey) {
            this.label = label;
            this.url = url;
            this.confirmationKey = confirmationKey;
        }

        public void addChild(Menu child) {
            if (child != null) {
                child.parent = this;
                if (this.children == null) {
                    this.children = new ArrayList<Menu>();
                }
                this.children.add(child);
            }
        }

        public List<Menu> getChildren() {
            return this.children;
        }

        public String getConfirmationKey() {
            return this.confirmationKey;
        }

        public String getLabel() {
            return this.label;
        }

        public Menu getParent() {
            return this.parent;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean hasContent() {
            return this.url != null || this.children != null;
        }

        public boolean isNested() {
            return this.parent != null;
        }
    }
}

