/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MultiDropDownTag
extends TagSupport {
    private static final long serialVersionUID = 7107831808471414750L;
    private String divId;
    private Integer maxWidth;
    private Integer minWidth;
    private String name;
    private boolean singleField;
    private boolean open;
    private boolean disabled;
    private Integer size;
    private List<String> selectedValues;
    private String emptyLabel;
    private String emptyLabelKey;
    private String varName;
    private String onchange;
    private MessageHelper messageHelper;

    public MultiDropDownTag() {
        this.release();
    }

    public int doEndTag() throws JspException {
        try {
            StringBuilder options = new StringBuilder();
            options.append('{');
            options.append("'singleField':").append(this.singleField).append(',');
            options.append("'open':").append(this.open).append(',');
            options.append("'disabled':").append(this.disabled);
            if (this.size != null) {
                options.append(",'size':").append(this.size);
            }
            if (this.minWidth != null) {
                options.append(",'minWidth':").append(this.minWidth);
            }
            if (this.maxWidth != null) {
                options.append(",'maxWidth':").append(this.maxWidth);
            }
            if (this.emptyLabelKey != null) {
                this.emptyLabel = this.messageHelper.message(this.emptyLabelKey, new Object[0]);
            }
            if (this.emptyLabel != null) {
                options.append(",'emptyLabel':\"").append(StringEscapeUtils.escapeJavaScript((String)this.emptyLabel)).append('\"');
            }
            if (this.onchange != null) {
                options.append(",'onchange':\"").append(StringEscapeUtils.escapeJavaScript((String)this.onchange)).append('\"');
            }
            options.append('}');
            JspWriter out = this.pageContext.getOut();
            if (StringUtils.isNotEmpty((String)this.varName)) {
                out.print(this.varName + "=");
            }
            out.println("new MultiDropDown(" + this.divId + ", '" + this.name + "', " + this.divId + ".values, " + options + ")");
            out.println("</script>");
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public int doStartTag() throws JspException {
        this.divId = "_container_" + System.currentTimeMillis() + "_" + new Random().nextInt(Integer.MAX_VALUE);
        if (this.selectedValues == null) {
            try {
                Object form = this.pageContext.findAttribute("org.apache.struts.taglib.html.BEAN");
                this.selectedValues = CoercionHelper.coerce(List.class, PropertyHelper.get(form, this.name));
                for (int i = 0; i < this.selectedValues.size(); ++i) {
                    this.selectedValues.set(i, CoercionHelper.coerce(String.class, this.selectedValues.get(i)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.print("<div");
            if (this.maxWidth != null) {
                out.print(" style='width:" + this.maxWidth + "px'");
            }
            out.println(" id='" + this.divId + "'></div>");
            out.println("<script>");
            out.println("var mddNoItemsMessage = \"" + StringEscapeUtils.escapeJavaScript((String)this.messageHelper.message("multiDropDown.noItemsMessage", new Object[0])) + "\";");
            out.println("var mddSingleItemsMessage = \"" + StringEscapeUtils.escapeJavaScript((String)this.messageHelper.message("multiDropDown.singleItemMessage", new Object[0])) + "\";");
            out.println("var mddMultiItemsMessage = \"" + StringEscapeUtils.escapeJavaScript((String)this.messageHelper.message("multiDropDown.multiItemsMessage", new Object[0])) + "\";");
            out.println("var " + this.divId + " = $('" + this.divId + "');");
            out.println(this.divId + ".values = [];");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 1;
    }

    public String getDivId() {
        return this.divId;
    }

    public String getEmptyLabel() {
        return this.emptyLabel;
    }

    public String getEmptyLabelKey() {
        return this.emptyLabelKey;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public Integer getMinWidth() {
        return this.minWidth;
    }

    public String getName() {
        return this.name;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public Object getSelected() {
        return this.selectedValues;
    }

    public List<String> getSelectedValues() {
        return this.selectedValues;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getVarName() {
        return this.varName;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isSingleField() {
        return this.singleField;
    }

    public void release() {
        super.release();
        this.divId = null;
        this.maxWidth = null;
        this.minWidth = null;
        this.size = null;
        this.name = null;
        this.emptyLabel = null;
        this.emptyLabelKey = null;
        this.selectedValues = null;
        this.singleField = false;
        this.open = false;
        this.disabled = false;
        this.varName = null;
        this.onchange = null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setEmptyLabel(String emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public void setEmptyLabelKey(String emptyLabelKey) {
        this.emptyLabelKey = emptyLabelKey;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMinWidth(Integer minWidth) {
        this.minWidth = minWidth;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.messageHelper = SpringHelper.bean(pageContext.getServletContext(), MessageHelper.class);
    }

    public void setSelected(Object object) {
        if (object == null) {
            this.selectedValues = null;
        } else {
            Iterator it = IteratorUtils.getIterator((Object)object);
            this.selectedValues = new ArrayList<String>();
            while (it.hasNext()) {
                this.selectedValues.add(CoercionHelper.coerce(String.class, it.next()));
            }
        }
    }

    public void setSelectedValues(List<String> selectedValues) {
        this.selectedValues = selectedValues;
    }

    public void setSingleField(boolean singleField) {
        this.singleField = singleField;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }
}

