/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.query.Page;
import org.apache.commons.lang.StringUtils;

public class PaginationTag
extends TagSupport {
    private static final long serialVersionUID = 6787858661511733003L;
    private String form;
    private Object items;
    private String onClickHandler;

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            if (!(this.items instanceof Page)) {
                out.println("<!-- pagination tag: items is not a page -->");
                int n = 6;
                return n;
            }
            out.println("<span style='vertical-align:middle'>");
            Page page = (Page)this.items;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            int currentPage = page.getCurrentPage() + 1;
            int pageCount = page.getPageCount();
            if (!page.isEmpty()) {
                MessageHelper messageHelper = SpringHelper.bean(this.pageContext.getServletContext(), MessageHelper.class);
                if (pageCount == 1) {
                    out.println(messageHelper.message("global.pagination.single.page", page.getTotalCount()));
                } else {
                    out.println(messageHelper.message("global.pagination.various.pages", page.getTotalCount()));
                    if (currentPage > 1) {
                        out.println(this.pageLink(currentPage - 1, "<img src=\"" + request.getContextPath() + "/pages/images/previous.gif\" style=\"valign:bottom\" border=\"0\" title=\"" + messageHelper.message("global.pagination.tooltip.previous", new Object[0]) + "\">"));
                    }
                    out.println(StringUtils.join((Object[])this.resolvePages(currentPage, pageCount), (char)' '));
                    if (currentPage < pageCount) {
                        out.println(this.pageLink(currentPage + 1, "<img src=\"" + request.getContextPath() + "/pages/images/next.gif\" style=\"valign:bottom\" border=\"0\" title=\"" + messageHelper.message("global.pagination.tooltip.next", new Object[0]) + "\">"));
                    }
                }
            }
            out.println("</span>");
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public String getForm() {
        return this.form;
    }

    public Object getItems() {
        return this.items;
    }

    public String getOnClickHandler() {
        return this.onClickHandler;
    }

    public void release() {
        super.release();
        this.items = null;
        this.form = null;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public void setItems(Object items) {
        this.items = items;
    }

    public void setOnClickHandler(String onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    private String buildPageLink(int currentPage, int page) {
        if (page == currentPage) {
            return "<span class='currentPage'>" + currentPage + "</span>";
        }
        return this.pageLink(page, String.valueOf(page));
    }

    private String pageLink(int page, String label) {
        return "<a onClickHandler='" + StringUtils.trimToEmpty((String)this.onClickHandler) + "' jumpToPage='" + (page - 1) + "' " + (StringUtils.isNotEmpty((String)this.form) ? "form='" + this.form + "'" : "") + " class='paginationLink'>" + label + "</a>";
    }

    private String[] resolvePages(int currentPage, int pageCount) {
        ArrayList<String> pages = new ArrayList<String>();
        if (currentPage >= 3) {
            pages.add(this.buildPageLink(currentPage, 1));
            if (currentPage >= 4) {
                pages.add("...");
            }
        }
        if (currentPage > 1) {
            pages.add(this.buildPageLink(currentPage, currentPage - 1));
        }
        pages.add(this.buildPageLink(currentPage, currentPage));
        if (currentPage < pageCount) {
            pages.add(this.buildPageLink(currentPage, currentPage + 1));
        }
        if (currentPage <= pageCount - 2) {
            if (currentPage <= pageCount - 1) {
                pages.add("...");
            }
            pages.add(this.buildPageLink(currentPage, pageCount));
        }
        return pages.toArray(new String[pages.size()]);
    }
}

