/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.taglibs.TruncateTag;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.cxf.common.util.StringUtils;

public class ProfileTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private Long elementId = null;
    private String text = null;
    private Integer fieldLength = 60;
    private String pattern = null;
    private String styleClass = null;
    private boolean onlyShowLabel = false;
    private ElementService elementService;
    private PermissionService permissionService;
    private SettingsService settingsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            try {
                out.write(this.generateProfileField());
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        finally {
            this.release();
        }
        return 6;
    }

    public Long getElementId() {
        return this.elementId;
    }

    public Integer getFieldLength() {
        return this.fieldLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getText() {
        return this.text;
    }

    public boolean isOnlyShowLabel() {
        return this.onlyShowLabel;
    }

    public void release() {
        super.release();
        this.elementId = null;
        this.text = null;
        this.pattern = null;
        this.fieldLength = 60;
        this.styleClass = null;
        this.onlyShowLabel = false;
    }

    public void setElementId(Long elementId) {
        this.elementId = elementId;
    }

    public void setFieldLength(Integer fieldLength) {
        this.fieldLength = fieldLength;
    }

    public void setOnlyShowLabel(boolean onlyShowLabel) {
        this.onlyShowLabel = onlyShowLabel;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.elementService = SpringHelper.bean(pageContext.getServletContext(), ElementService.class);
        this.permissionService = SpringHelper.bean(pageContext.getServletContext(), PermissionService.class);
        this.settingsService = SpringHelper.bean(pageContext.getServletContext(), SettingsService.class);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setText(String text) {
        this.text = text;
    }

    private String generateProfileField() {
        String profile;
        if (this.elementId <= 0L) {
            return "";
        }
        final ElementVO element = this.elementService.getElementVO(this.elementId);
        boolean canGoToProfile = false;
        Object foundGroup = CollectionUtils.find(this.permissionService.getAllVisibleGroups(), (Predicate)new Predicate(){

            public boolean evaluate(Object group) {
                return ((Group)group).getId().equals(element.getGroupId());
            }
        });
        if (foundGroup != null) {
            canGoToProfile = true;
        }
        if (StringUtils.isEmpty((String)this.text)) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            LocalSettings.MemberResultDisplay memberResultDisplay = localSettings.getMemberResultDisplay();
            if (this.pattern != null) {
                this.text = this.pattern.replaceAll("username", element.getUsername()).replaceAll("name", element.getName());
            } else if (memberResultDisplay == LocalSettings.MemberResultDisplay.NAME) {
                this.text = element.getName();
            } else if (memberResultDisplay == LocalSettings.MemberResultDisplay.USERNAME) {
                this.text = element.getUsername();
            }
        }
        this.text = TruncateTag.truncate(this.text, this.fieldLength);
        if (canGoToProfile && !this.onlyShowLabel) {
            profile = "<a class=\"$linkClass\" $attribute=\"$id\">$text</a>";
            String linkClass = "";
            String attribute = "";
            switch (element.getNature()) {
                case ADMIN: {
                    linkClass = "adminProfileLink";
                    attribute = "adminId";
                    break;
                }
                case MEMBER: {
                    linkClass = "profileLink";
                    attribute = "memberId";
                    break;
                }
                case OPERATOR: {
                    linkClass = "operatorProfileLink";
                    attribute = "operatorId";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected element identifier " + this.elementId);
                }
            }
            if (!StringUtils.isEmpty((String)this.styleClass)) {
                linkClass = linkClass + " " + this.styleClass;
            }
            profile = profile.replace("$linkClass", linkClass);
            profile = profile.replace("$attribute", attribute);
            profile = profile.replace("$id", this.elementId.toString());
            profile = profile.replace("$text", this.text);
        } else {
            profile = this.text;
        }
        return profile;
    }
}

