/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import nl.strohalm.cyclos.taglibs.AbstractDynamicAttributesTag;
import org.apache.commons.lang.StringUtils;

public class RichTextAreaTag
extends AbstractDynamicAttributesTag {
    private static final long serialVersionUID = -1526709179401334789L;
    private String name;
    private String value;
    private boolean disabled;
    private String styleClass;
    private String styleId;

    public RichTextAreaTag() {
        this.release();
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        String value = this.value;
        String id = StringUtils.isEmpty((String)this.styleId) ? this.name : this.styleId;
        try {
            StringBuilder sb = new StringBuilder();
            if (this.disabled) {
                sb.append("<div style='position:relative;padding-right:6px;'><div id='textOfField_").append(id).append("' class='fakeFieldDisabled' style='width:479px;height:200px;overflow:auto;'><table cellpadding='0' cellspacing='0' border='0' width='100%'><tr><td style='padding:0px'>");
                sb.append(StringUtils.isEmpty((String)value) ? "&nbsp;" : value);
                sb.append("</td></tr></table></div></div>");
                sb.append("<div id='envelopeOfField_").append(id).append("' style='display:none'>");
            }
            StringBuilder className = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.styleClass)) {
                className.append(this.styleClass);
            }
            className.append(" full");
            className.append(this.disabled ? " richEditorDisabled" : " richEditor");
            String containerId = "container_" + id;
            sb.append("<div class='richTextAreaContainer' id=\"").append(containerId).append("\">");
            sb.append("<textarea rows='6' name='").append(this.name).append('\'');
            if (StringUtils.isNotEmpty((String)this.styleId)) {
                sb.append(" id='" + this.styleId + '\'');
                sb.append(" fieldId='" + this.styleId + '\'');
            }
            sb.append(" class='").append((CharSequence)className).append('\'');
            sb.append(' ').append(this.attributesForTag()).append('>');
            sb.append(value);
            sb.append("</textarea>");
            sb.append("</div>");
            if (this.disabled) {
                sb.append("</div>");
            } else {
                sb.append("<script>\n");
                sb.append("richEditorsToInitialize.push($('").append(containerId).append("').firstChild);\n");
                sb.append("</script>\n");
            }
            out.print(sb.toString());
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void release() {
        this.value = null;
        this.disabled = false;
        this.name = null;
        this.styleClass = null;
        this.styleId = null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

