/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;

public class ScriptTag
extends TagSupport {
    private static final long serialVersionUID = 5044196774749124533L;
    private String src;

    public int doEndTag() throws JspException {
        this.src = StringUtils.trimToNull((String)this.src);
        if (this.src != null) {
            try {
                this.pageContext.getOut().println(this.generateScriptTag());
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
            finally {
                this.release();
            }
        }
        return 6;
    }

    public String generateScriptTag() {
        StringBuilder sb = new StringBuilder();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String fullPath = request.getContextPath() + this.src;
        Object version = this.pageContext.getServletContext().getAttribute("cyclosVersion");
        sb.append("<script language=\"javascript\" src=\"").append(fullPath).append("?version=").append(version).append("\"></script>");
        return sb.toString();
    }

    public String getSrc() {
        return this.src;
    }

    public void release() {
        super.release();
        this.src = null;
    }

    public void setSrc(String src) {
        this.src = src;
    }
}

