/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.utils.StringHelper;
import org.apache.commons.lang.StringUtils;

public class TruncateTag
extends TagSupport {
    public static final int DEFAULT_LENGTH = 60;
    public static final int DEFAULT_LINES = 1;
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("[\\r\\n]+", 2);
    private static final Pattern BREAK_TAG_PATTERN = Pattern.compile("<(p|br)[^>]*>", 2);
    private static final Pattern PARAGRAPH_END_TAG_PATTERN = Pattern.compile("<\\/p[^>]*>", 2);
    private static final Pattern DOUBLE_SPACE_PATTERN = Pattern.compile("\\s\\s+");
    private static final Pattern SPACE_BREAK_PATTERN = Pattern.compile("\\s[\\n|\\s]+");
    private static final long serialVersionUID = 7763882160354732177L;
    private Object value;
    private int length = 60;
    private int lines = 1;
    private boolean html;

    public static String truncate(Object object, int length) {
        return TruncateTag.truncate(object, length, 1);
    }

    public static String truncate(Object object, int length, int lines) {
        return TruncateTag.truncate(object, length, lines, false);
    }

    public static String truncate(Object object, int length, int lines, boolean html) {
        int i;
        if (object == null) {
            return "";
        }
        String string = StringUtils.trimToEmpty((String)object.toString());
        if (html) {
            string = LINE_BREAK_PATTERN.matcher(string).replaceAll("\n");
            string = BREAK_TAG_PATTERN.matcher(string).replaceAll("\n");
            string = PARAGRAPH_END_TAG_PATTERN.matcher(string).replaceAll("");
            string = StringHelper.removeMarkupTagsAndUnescapeEntities(string);
            string = SPACE_BREAK_PATTERN.matcher(string).replaceAll("\n");
            string = DOUBLE_SPACE_PATTERN.matcher(string).replaceAll(" ");
        } else {
            string = StringUtils.replace((String)string, (String)"\r", (String)"");
        }
        String[] stringLines = StringUtils.split((String)string, (char)'\n');
        if (lines > 0) {
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < lines && i < stringLines.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(stringLines[i]);
            }
            string = sb.toString();
        }
        if (string.length() > length) {
            int pos = length - 3;
            for (i = 0; i < Math.min(length - 3, 10); ++i) {
                char c = string.charAt(pos - i);
                if (!Character.isWhitespace(c) && ".,()!?".indexOf(c) < 0) continue;
                pos -= i;
                break;
            }
            string = string.substring(0, pos).trim() + "...";
        }
        return string;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write(TruncateTag.truncate(this.value, this.length, this.lines, this.html));
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public int getLength() {
        return this.length;
    }

    public int getLines() {
        return this.lines;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void release() {
        super.release();
        this.value = null;
        this.lines = 1;
        this.length = 60;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLines(int maxRows) {
        this.lines = maxRows;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

