/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.themes;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.themes.Theme;
import nl.strohalm.cyclos.themes.ThemeHandler;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public abstract class BaseThemeHandler
implements ThemeHandler {
    private PermissionService permissionService;

    @Override
    public void export(Theme theme, OutputStream out) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_EXPORT)) {
            throw new PermissionDeniedException();
        }
        this.doExport(theme, out);
    }

    @Override
    public void importNew(String fileName, InputStream in) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_IMPORT)) {
            throw new PermissionDeniedException();
        }
        this.doImportNew(fileName, in);
    }

    @Override
    public List<Theme> list() {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_SELECT)) {
            throw new PermissionDeniedException();
        }
        return this.doList();
    }

    @Override
    public void remove(String fileName) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_REMOVE)) {
            throw new PermissionDeniedException();
        }
        this.doRemove(fileName);
    }

    @Override
    public void select(String fileName) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_SELECT)) {
            throw new PermissionDeniedException();
        }
        this.doSelect(fileName);
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void validateForExport(Theme theme) throws ValidationException {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_EXPORT)) {
            throw new PermissionDeniedException();
        }
        this.doValidateForExport(theme);
    }

    protected abstract void doExport(Theme var1, OutputStream var2);

    protected abstract void doImportNew(String var1, InputStream var2);

    protected abstract List<Theme> doList();

    protected abstract void doRemove(String var1);

    protected abstract void doSelect(String var1);

    protected abstract void doValidateForExport(Theme var1) throws ValidationException;
}

