/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.themes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.collections.CollectionUtils;

public class Theme
extends DataObject
implements Comparable<Theme> {
    private static final long serialVersionUID = -1863957027992677264L;
    private String title;
    private String author;
    private String version;
    private String description;
    private String filename;
    private Collection<Style> styles;

    @Override
    public int compareTo(Theme o) {
        return this.title == null ? -1 : this.title.compareTo(o.title);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.filename;
    }

    public Collection<Style> getStyles() {
        return this.styles;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setStyles(Collection<Style> styles) {
        this.styles = styles;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static enum Style {
        MAIN("style.css", "ieAdjust.css", "posweb.css"),
        LOGIN("login.css"),
        MOBILE("mobile.css");

        private final Collection<String> files;

        public static Set<Style> resolveFromFiles(Collection<String> files) {
            EnumSet<Style> set = EnumSet.noneOf(Style.class);
            if (files != null) {
                for (Style whatToExport : Style.values()) {
                    if (!CollectionUtils.containsAny(whatToExport.files, files)) continue;
                    set.add(whatToExport);
                }
            }
            return set;
        }

        private Style(String ... files) {
            this.files = Collections.unmodifiableCollection(Arrays.asList(files));
        }

        public Collection<String> getFiles() {
            return this.files;
        }
    }
}

