/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.themes;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.themes.BaseThemeHandler;
import nl.strohalm.cyclos.themes.Theme;
import nl.strohalm.cyclos.themes.exceptions.ThemeException;
import nl.strohalm.cyclos.themes.exceptions.ThemeNotFoundException;
import nl.strohalm.cyclos.utils.CSSHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.WebImageHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class ThemeHandlerImpl
extends BaseThemeHandler
implements ServletContextAware {
    private static final String THEME_PROPERTIES_ENTRY = "theme.properties";
    private static final String THEMES_PATH = "/WEB-INF/themes/";
    private static final FilenameFilter THEME_FILTER = new SuffixFileFilter(".theme");
    private static final FilenameFilter STYLE_FILTER = new SuffixFileFilter(".css");
    private static final FileFilter IMAGE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            try {
                ImageHelper.ImageType.getByContent(pathname);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    private ServletContext context;
    private ImageService imageService;
    private CustomizedFileService customizedFileService;
    private CustomizationHelper customizationHelper;
    private WebImageHelper webImageHelper;
    private SettingsService settingsService;

    private static Properties properties(ZipFile zipFile) throws IOException {
        ZipEntry propertiesEntry = zipFile.getEntry(THEME_PROPERTIES_ENTRY);
        if (propertiesEntry == null) {
            throw new FileNotFoundException(THEME_PROPERTIES_ENTRY);
        }
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(propertiesEntry));
        return properties;
    }

    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    public void setCustomizedFileService(CustomizedFileService customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void setWebImageHelper(WebImageHelper webImageHelper) {
        this.webImageHelper = webImageHelper;
    }

    @Override
    protected void doExport(Theme theme, OutputStream out) {
        this.validateForExport(theme);
        ZipOutputStream zipOut = new ZipOutputStream(out);
        LocalSettings settings = this.settingsService.getLocalSettings();
        String charset = settings.getCharset();
        try {
            File[] imageFiles;
            ArrayList<String> exportedFiles = new ArrayList<String>();
            ArrayList<String> exportedImages = new ArrayList<String>();
            Collection<Theme.Style> styles = theme.getStyles();
            if (styles != null) {
                for (Theme.Style style : styles) {
                    exportedFiles.addAll(style.getFiles());
                }
            }
            Properties properties = this.asProperties(theme);
            zipOut.putNextEntry(new ZipEntry(THEME_PROPERTIES_ENTRY));
            properties.store(zipOut, "");
            zipOut.closeEntry();
            List<File> styleFiles = this.customizationHelper.listByType(CustomizedFile.Type.STYLE);
            for (File file : styleFiles) {
                String name = file.getName();
                if (!exportedFiles.contains(name)) continue;
                file = this.customizationHelper.findFileOf(CustomizedFile.Type.STYLE, null, name);
                String contents = FileUtils.readFileToString((File)file, (String)charset);
                exportedImages.addAll(CSSHelper.resolveURLs(contents));
                zipOut.putNextEntry(new ZipEntry("styles/" + name));
                IOUtils.copy((Reader)new StringReader(contents), (OutputStream)zipOut, (String)charset);
                zipOut.closeEntry();
            }
            File dir = this.webImageHelper.imagePath(Image.Nature.STYLE);
            for (File file : imageFiles = dir.listFiles(IMAGE_FILTER)) {
                String name = file.getName();
                if (!exportedImages.contains(name)) continue;
                zipOut.putNextEntry(new ZipEntry("images/" + name));
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)zipOut);
                zipOut.closeEntry();
            }
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOut);
        }
    }

    @Override
    protected void doImportNew(String fileName, InputStream in) {
        File file = this.realFile(fileName);
        try {
            byte[] data = IOUtils.toByteArray((InputStream)in);
            this.customizationHelper.updateFile(file, System.currentTimeMillis(), data);
        }
        catch (Exception e) {
            throw new ThemeException();
        }
    }

    @Override
    protected List<Theme> doList() {
        String path = this.context.getRealPath(THEMES_PATH);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File[] files = dir.listFiles(THEME_FILTER);
        ArrayList<Theme> themes = new ArrayList<Theme>(files.length);
        for (File file : files) {
            try {
                themes.add(this.read(file));
            }
            catch (ThemeException e) {
                // empty catch block
            }
        }
        Collections.sort(themes);
        return themes;
    }

    @Override
    protected void doRemove(String fileName) {
        File file = this.realFile(fileName);
        if (!file.exists()) {
            throw new ThemeNotFoundException(fileName);
        }
        this.customizationHelper.deleteFile(file);
    }

    @Override
    protected void doSelect(String fileName) {
        ZipFile zipFile = null;
        LocalSettings settings = this.settingsService.getLocalSettings();
        String charset = settings.getCharset();
        try {
            File[] cssFiles;
            File file = this.realFile(fileName);
            if (!file.exists()) {
                throw new ThemeNotFoundException(fileName);
            }
            zipFile = new ZipFile(file);
            ThemeHandlerImpl.properties(zipFile);
            HashMap<String, List<String>> imagesByFile = new HashMap<String, List<String>>();
            File imageDir = this.webImageHelper.imagePath(Image.Nature.STYLE);
            for (File css : cssFiles = imageDir.listFiles(STYLE_FILTER)) {
                String contents = FileUtils.readFileToString((File)css, (String)charset);
                List<String> urls = CSSHelper.resolveURLs(contents);
                imagesByFile.put(css.getName(), urls);
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                String entryFileName = new File(name).getName();
                if (name.startsWith("images/")) {
                    ImageHelper.ImageType type = ImageHelper.ImageType.getByFileName(entryFileName);
                    Image image = this.imageService.save(Image.Nature.STYLE, type, entryFileName, zipFile.getInputStream(entry));
                    this.webImageHelper.update(image);
                    continue;
                }
                if (!name.startsWith("styles/")) continue;
                CustomizedFile customizedFile = new CustomizedFile();
                customizedFile.setName(entryFileName);
                customizedFile.setType(CustomizedFile.Type.STYLE);
                String contents = IOUtils.toString((InputStream)zipFile.getInputStream(entry), (String)charset);
                customizedFile.setContents(contents);
                File originalFile = this.customizationHelper.originalFileOf(CustomizedFile.Type.STYLE, entryFileName);
                if (originalFile.exists()) {
                    customizedFile.setOriginalContents(FileUtils.readFileToString((File)originalFile, (String)charset));
                }
                customizedFile = this.customizedFileService.saveForTheme(customizedFile);
                File physicalFile = this.customizationHelper.customizedFileOf(CustomizedFile.Type.STYLE, entryFileName);
                this.customizationHelper.updateFile(physicalFile, customizedFile);
                List<String> newImages = CSSHelper.resolveURLs(contents);
                Collection oldImages = (Collection)imagesByFile.get(entryFileName);
                if (!CollectionUtils.isNotEmpty((Collection)oldImages)) continue;
                for (String imageName : oldImages) {
                    if (newImages.contains(imageName)) continue;
                    this.imageService.removeStyleImage(imageName);
                    File imageFile = new File(imageDir, imageName);
                    this.customizationHelper.deleteFile(imageFile);
                }
            }
        }
        catch (ThemeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    protected void doValidateForExport(Theme theme) throws ValidationException {
        this.getExportValidator().validate(theme);
    }

    private Properties asProperties(Theme theme) {
        Properties properties = new Properties();
        properties.setProperty("title", StringUtils.trimToEmpty((String)theme.getTitle()));
        properties.setProperty("author", StringUtils.trimToEmpty((String)theme.getAuthor()));
        properties.setProperty("version", StringUtils.trimToEmpty((String)theme.getVersion()));
        properties.setProperty("description", StringUtils.trimToEmpty((String)theme.getDescription()));
        Collection<String> strings = CoercionHelper.coerceCollection(String.class, theme.getStyles());
        properties.setProperty("styles", StringUtils.join(strings.iterator(), (char)','));
        return properties;
    }

    private Theme fromProperties(Properties properties) {
        Theme theme = new Theme();
        theme.setTitle(StringUtils.trimToNull((String)properties.getProperty("title")));
        theme.setAuthor(StringUtils.trimToNull((String)properties.getProperty("author")));
        theme.setVersion(StringUtils.trimToNull((String)properties.getProperty("version")));
        theme.setDescription(StringUtils.trimToNull((String)properties.getProperty("description")));
        String styles = StringUtils.trimToNull((String)properties.getProperty("styles"));
        if (styles == null) {
            theme.setStyles(EnumSet.allOf(Theme.Style.class));
        } else {
            String[] array = StringUtils.split((String)styles, (char)',');
            theme.setStyles(CoercionHelper.coerceCollection(Theme.Style.class, array));
        }
        return theme;
    }

    private Validator getExportValidator() {
        Validator exportValidator = new Validator("theme");
        exportValidator.property("title").required();
        exportValidator.property("filename").required();
        exportValidator.property("styles").key("theme.stylesToExport").required();
        return exportValidator;
    }

    private Theme read(File file) throws ThemeException {
        ZipFile zipFile = null;
        try {
            if (!file.exists()) {
                throw new ThemeNotFoundException(file.getName());
            }
            zipFile = new ZipFile(file);
            Properties properties = ThemeHandlerImpl.properties(zipFile);
            Theme theme = this.fromProperties(properties);
            theme.setFilename(file.getName());
            Theme theme2 = theme;
            return theme2;
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception e) {}
        }
    }

    private File realFile(String fileName) {
        String path = this.context.getRealPath(THEMES_PATH);
        return new File(path, fileName);
    }
}

