/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.themes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.themes.Theme;
import nl.strohalm.cyclos.themes.exceptions.ThemeException;
import nl.strohalm.cyclos.themes.exceptions.ThemeNotFoundException;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;

public class ThemeHelper {
    private static final String THEME_PROPERTIES_ENTRY = "/theme.properties";
    private static final FilenameFilter FILENAME_FILTER = new SuffixFileFilter(".theme");
    private static final String THEMES_PATH = "/WEB-INF/themes/";

    public static List<Theme> listThemes(ServletContext context) {
        String path = context.getRealPath(THEMES_PATH);
        File[] files = new File(path).listFiles(FILENAME_FILTER);
        ArrayList<Theme> themes = new ArrayList<Theme>(files.length);
        for (File file : files) {
            try {
                themes.add(ThemeHelper.read(file));
            }
            catch (ThemeException e) {
                // empty catch block
            }
        }
        return themes;
    }

    public static File realFile(ServletContext context, String fileName) {
        String path = context.getRealPath(THEMES_PATH);
        return new File(path, fileName);
    }

    public static void remove(ServletContext context, String fileName) throws ThemeNotFoundException {
        File file = ThemeHelper.realFile(context, fileName);
        if (!file.exists()) {
            throw new ThemeNotFoundException(fileName);
        }
        CustomizationHelper customizationHelper = SpringHelper.bean(context, CustomizationHelper.class);
        customizationHelper.deleteFile(file);
    }

    public static void select(ServletContext context, String fileName) throws ThemeException {
        try {
            File file = ThemeHelper.realFile(context, fileName);
            if (!file.exists()) {
                throw new ThemeNotFoundException(fileName);
            }
            ZipFile zipFile = new ZipFile(file);
            ThemeHelper.properties(zipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("/images")) continue;
            }
        }
        catch (ThemeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
    }

    private static Theme fromProperties(Properties properties) {
        Theme theme = new Theme();
        theme.setTitle(StringUtils.trimToNull((String)properties.getProperty("title")));
        theme.setAuthor(StringUtils.trimToNull((String)properties.getProperty("author")));
        theme.setVersion(StringUtils.trimToNull((String)properties.getProperty("version")));
        theme.setDescription(StringUtils.trimToNull((String)properties.getProperty("description")));
        return theme;
    }

    private static Properties properties(ZipFile zipFile) throws IOException {
        ZipEntry propertiesEntry = zipFile.getEntry(THEME_PROPERTIES_ENTRY);
        if (propertiesEntry == null) {
            throw new FileNotFoundException(THEME_PROPERTIES_ENTRY);
        }
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(propertiesEntry));
        return properties;
    }

    private static Theme read(File file) throws ThemeException {
        try {
            if (!file.exists()) {
                throw new ThemeNotFoundException(file.getName());
            }
            ZipFile zipFile = new ZipFile(file);
            Properties properties = ThemeHelper.properties(zipFile);
            Theme theme = ThemeHelper.fromProperties(properties);
            theme.setFilename(file.getName());
            return theme;
        }
        catch (Exception e) {
            throw new ThemeException(e);
        }
    }
}

