/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.alerts.ErrorLogService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.TransferMinimumPaymentException;
import nl.strohalm.cyclos.services.transactions.exceptions.UpperCreditLimitReachedException;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class ActionHelper {
    private ErrorLogService errorLogService;
    private SettingsService settingsService;

    public static ActionForward back(ActionMapping actionMapping) {
        return actionMapping.findForward("back");
    }

    public static Collection<Map<String, Object>> getByElements(ActionContext context, Collection<? extends Entity> entities, ByElementExtractor extractor) {
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> byCollection = new ArrayList<Map<String, Object>>();
        for (Entity entity : entities) {
            Element by = extractor.getByElement(entity);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (by == null) {
                map.put("byType", "SystemTask");
            } else if (by.getNature() == Element.Nature.ADMIN) {
                if (context.isAdmin()) {
                    map.put("by", by);
                    map.put("byType", "Admin");
                } else {
                    map.put("byType", "System");
                }
            } else if (by.getNature() == Element.Nature.OPERATOR && (context.isMemberOf(EntityHelper.reference(Operator.class, by.getId())) || ((Entity)context.getElement()).equals(by))) {
                map.put("by", by);
                map.put("byType", "Operator");
            } else {
                map.put("by", by.getAccountOwner());
                map.put("byType", "Member");
            }
            byCollection.add(map);
        }
        return byCollection;
    }

    public static Map<String, String[]> getParameterMap(HttpServletRequest request) {
        HttpSession session;
        String uri = request.getRequestURI();
        Map clientParameterMap = request.getParameterMap();
        if (uri.endsWith("/error") && (session = request.getSession(false)) != null) {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.putAll(clientParameterMap);
            map.put("errorKey", new String[]{(String)request.getAttribute("errorKey")});
            return map;
        }
        return clientParameterMap;
    }

    public static ActionForward handleValidationException(ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, ValidationException e) {
        Map.Entry<String, Collection<ValidationError>> entry;
        Collection<ValidationError> errors;
        if (e == null) {
            return null;
        }
        String key = "error.validation";
        List<Object> args = Collections.emptyList();
        if (!e.getGeneralErrors().isEmpty()) {
            ValidationError error = e.getGeneralErrors().iterator().next();
            key = error.getKey();
            args = error.getArguments();
        } else if (!e.getErrorsByProperty().isEmpty() && !(errors = (entry = e.getErrorsByProperty().entrySet().iterator().next()).getValue()).isEmpty()) {
            String propertyName = entry.getKey();
            ValidationError error = errors.iterator().next();
            key = error.getKey();
            args = new ArrayList();
            String propertyLabel = e.getPropertyDisplayName(propertyName);
            if (StringUtils.isEmpty((String)propertyLabel)) {
                String propertyKey = e.getPropertyKey(propertyName);
                if (StringUtils.isNotEmpty((String)propertyKey)) {
                    MessageHelper messageHelper = SpringHelper.bean(request.getSession().getServletContext(), MessageHelper.class);
                    propertyLabel = messageHelper.message(e.getPropertyKey(propertyName), new Object[0]);
                } else {
                    propertyLabel = propertyName;
                }
            }
            args.add(propertyLabel);
            if (error.getArguments() != null) {
                args.addAll(error.getArguments());
            }
        }
        return ActionHelper.sendError(actionMapping, request, response, key, args.toArray());
    }

    public static ActionForward redirectWithParam(HttpServletRequest request, ActionForward forward, String name, Object value) {
        return ActionHelper.redirectWithParams(request, forward, Collections.singletonMap(name, value));
    }

    public static ActionForward redirectWithParams(HttpServletRequest request, ActionForward forward, Map<String, Object> params) {
        if (forward == null) {
            return null;
        }
        LocalSettings settings = SpringHelper.bean(request.getSession().getServletContext(), SettingsService.class).getLocalSettings();
        forward = new ActionForward(forward);
        StringBuilder path = new StringBuilder();
        path.append(forward.getPath());
        if (MapUtils.isNotEmpty(params)) {
            path.append('?');
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                try {
                    path.append(entry.getKey()).append('=').append(URLEncoder.encode(value == null ? "" : value.toString(), settings.getCharset()));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                path.append('&');
            }
            if (path.charAt(path.length() - 1) == '&') {
                path.setLength(path.length() - 1);
            }
            forward.setPath(path.toString());
        }
        forward.setRedirect(true);
        return forward;
    }

    public static ActionForward sendError(ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, String key, Object ... arguments) {
        HttpSession session = request.getSession();
        session.setAttribute("errorKey", (Object)key);
        session.setAttribute("errorArguments", (Object)arguments);
        return actionMapping.findForward("error");
    }

    public static ActionForward sendErrorWithMessage(ActionMapping actionMapping, HttpServletRequest request, HttpServletResponse response, String message) {
        HttpSession session = request.getSession();
        session.setAttribute("errorMessage", (Object)message);
        return actionMapping.findForward("error");
    }

    public static void sendMessage(HttpServletRequest request, HttpServletResponse response, String key, Object ... arguments) {
        HttpSession session = request.getSession();
        session.setAttribute("messageKey", (Object)key);
        session.setAttribute("messageArguments", (Object)arguments);
        response.addCookie(new Cookie("showMessage", "true"));
    }

    public static void throwException(Throwable th) throws IOException, ServletException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof ServletException) {
            throw (ServletException)th;
        }
        if (th instanceof IOException) {
            throw (IOException)th;
        }
        throw new ServletException(th);
    }

    public void generateLog(HttpServletRequest request, ServletContext servletContext, Throwable error) {
        CurrentTransactionData.setError(error);
        HashMap parameters = new HashMap(request.getParameterMap());
        this.errorLogService.insert(error, request.getRequestURI(), parameters);
    }

    public ActionForward getForwardFor(Element.Nature nature, String actionName, boolean redirect) {
        ActionForward actionForward = new ActionForward("/do/" + nature.toString().toLowerCase() + "/" + actionName);
        actionForward.setRedirect(redirect);
        return actionForward;
    }

    public String resolveErrorKey(CreditsException exception) {
        if (exception instanceof MaxAmountPerDayExceededException) {
            MaxAmountPerDayExceededException e = (MaxAmountPerDayExceededException)exception;
            Calendar date = e.getDate();
            if (date == null || DateHelper.sameDay(date, Calendar.getInstance())) {
                return "payment.error.maxAmountOnDayExceeded";
            }
            return "payment.error.maxAmountOnDayExceeded.at";
        }
        if (exception instanceof NotEnoughCreditsException) {
            if (((NotEnoughCreditsException)exception).isOriginalAccount()) {
                return "payment.error.enoughCredits";
            }
            return "payment.error.enoughCreditsOtherAccount";
        }
        if (exception instanceof TransferMinimumPaymentException) {
            return "payment.error.transferMinimum";
        }
        if (exception instanceof UpperCreditLimitReachedException) {
            return "payment.error.upperCreditLimit";
        }
        return "error.general";
    }

    public Object[] resolveParameters(CreditsException exception) {
        if (exception instanceof MaxAmountPerDayExceededException) {
            MaxAmountPerDayExceededException e = (MaxAmountPerDayExceededException)exception;
            return new Object[]{e.getTransferType().getName(), this.settingsService.getLocalSettings().getRawDateConverter().toString(e.getDate())};
        }
        if (exception instanceof NotEnoughCreditsException) {
            return new Object[]{exception.getAccount().getType().getName()};
        }
        if (exception instanceof TransferMinimumPaymentException) {
            TransferMinimumPaymentException e = (TransferMinimumPaymentException)exception;
            return new Object[]{e.getMinimunPayment()};
        }
        if (exception instanceof UpperCreditLimitReachedException) {
            UpperCreditLimitReachedException e = (UpperCreditLimitReachedException)exception;
            return new Object[]{exception.getAccount().getType().getName(), e.getUpperLimit()};
        }
        return new Object[0];
    }

    public void setErrorLogService(ErrorLogService errorLogService) {
        this.errorLogService = errorLogService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public static interface ByElementExtractor {
        public Element getByElement(Entity var1);
    }
}

