/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Amount
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6344417251664586114L;
    private Type type;
    private BigDecimal value;

    public static Amount fixed(BigDecimal value) {
        Amount amount = new Amount();
        amount.setType(Type.FIXED);
        amount.setValue(value);
        return amount;
    }

    public static Amount percentage(BigDecimal value) {
        Amount amount = new Amount();
        amount.setType(Type.PERCENTAGE);
        amount.setValue(value);
        return amount;
    }

    public Amount() {
    }

    public Amount(BigDecimal value, Type type) {
        this.value = value;
        this.type = type;
    }

    public BigDecimal add(BigDecimal number) {
        BigDecimal applied = this.apply(number);
        if (applied == null) {
            return null;
        }
        return applied.add(number);
    }

    public BigDecimal apply(BigDecimal number) {
        if (this.value == null || this.type == null || number == null) {
            return number;
        }
        return this.type.apply(number, this.value);
    }

    public Amount clone() {
        try {
            return (Amount)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Amount)) {
            return false;
        }
        Amount amount = (Amount)obj;
        return new EqualsBuilder().append((Object)this.value, (Object)amount.value).append((Object)this.type, (Object)amount.type).isEquals();
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.value).append((Object)this.type).toHashCode();
    }

    public boolean isPercentage() {
        return this.type == Type.PERCENTAGE;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String toString() {
        return this.value + (this.type == Type.PERCENTAGE ? "%" : "");
    }

    public static enum Type implements StringValuedEnum
    {
        PERCENTAGE("P"),
        FIXED("F");

        private final String value;

        public static Type getFromValue(String value) {
            for (Type type : Type.values()) {
                if (!type.getValue().equals(value)) continue;
                return type;
            }
            return null;
        }

        private Type(String value) {
            this.value = value;
        }

        public BigDecimal apply(BigDecimal number, BigDecimal amount) {
            if (number == null || amount == null) {
                return number;
            }
            MathContext mathContext = new MathContext(6);
            if (this == FIXED) {
                return amount;
            }
            return number.multiply(amount).divide(new BigDecimal(100), mathContext);
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

