/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class BigDecimalHelper {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal(100.0);

    public static BigDecimal arctan(BigDecimal x, int scale) {
        if (x.abs().compareTo(BigDecimal.valueOf(1L)) >= 0) {
            throw new IllegalArgumentException("|x| >= 1");
        }
        if (x.signum() == -1) {
            return BigDecimalHelper.arctan(x.negate(), scale).negate();
        }
        return BigDecimalHelper.arctanTaylor(x, scale);
    }

    public static BigDecimal asPercentageOf(BigDecimal amount, BigDecimal total) {
        MathContext mathContext = new MathContext(10);
        BigDecimal asFractionOf = amount.divide(total, mathContext);
        return asFractionOf.multiply(ONE_HUNDRED, mathContext);
    }

    public static BigDecimal asPercentFraction(BigDecimal bigDecimal) {
        MathContext mathContext = new MathContext(10);
        return bigDecimal.divide(ONE_HUNDRED, mathContext);
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.valueOf(1L);
        }
        if (x.signum() == -1) {
            return BigDecimal.valueOf(1L).divide(BigDecimalHelper.exp(x.negate(), scale), scale, 6);
        }
        BigDecimal xWhole = x.setScale(0, 1);
        if (xWhole.signum() == 0) {
            return BigDecimalHelper.expTaylor(x, scale);
        }
        BigDecimal xFraction = x.subtract(xWhole);
        BigDecimal z = BigDecimal.valueOf(1L).add(xFraction.divide(xWhole, scale, 6));
        BigDecimal t = BigDecimalHelper.expTaylor(z, scale);
        BigDecimal maxLong = BigDecimal.valueOf(Long.MAX_VALUE);
        BigDecimal result = BigDecimal.valueOf(1L);
        while (xWhole.compareTo(maxLong) >= 0) {
            result = result.multiply(BigDecimalHelper.intPower(t, Long.MAX_VALUE, scale)).setScale(scale, 6);
            xWhole = xWhole.subtract(maxLong);
            Thread.yield();
        }
        return result.multiply(BigDecimalHelper.intPower(t, xWhole.longValue(), scale)).setScale(scale, 6);
    }

    public static BigDecimal intPower(BigDecimal x, long exponent, int scale) {
        if (exponent < 0L) {
            return BigDecimal.valueOf(1L).divide(BigDecimalHelper.intPower(x, -exponent, scale), scale, 6);
        }
        BigDecimal power = BigDecimal.valueOf(1L);
        while (exponent > 0L) {
            if ((exponent & 1L) == 1L) {
                power = power.multiply(x).setScale(scale, 6);
            }
            x = x.multiply(x).setScale(scale, 6);
            exponent >>= 1;
            Thread.yield();
        }
        return power;
    }

    public static BigDecimal intRoot(BigDecimal x, long index, int scale) {
        BigDecimal xPrev;
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal i = BigDecimal.valueOf(index);
        BigDecimal im1 = BigDecimal.valueOf(index - 1L);
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        x = x.divide(i, scale, 6);
        do {
            BigDecimal xToIm1 = BigDecimalHelper.intPower(x, index - 1L, sp1);
            BigDecimal xToI = x.multiply(xToIm1).setScale(sp1, 6);
            BigDecimal numerator = n.add(im1.multiply(xToI)).setScale(sp1, 6);
            BigDecimal denominator = i.multiply(xToIm1).setScale(sp1, 6);
            xPrev = x;
            x = numerator.divide(denominator, sp1, 1);
            Thread.yield();
        } while (x.subtract(xPrev).abs().compareTo(tolerance) > 0);
        return x;
    }

    public static BigDecimal ln(BigDecimal x, int scale) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException("x <= 0");
        }
        int magnitude = x.toString().length() - x.scale() - 1;
        if (magnitude < 3) {
            return BigDecimalHelper.lnNewton(x, scale);
        }
        BigDecimal root = BigDecimalHelper.intRoot(x, magnitude, scale);
        BigDecimal lnRoot = BigDecimalHelper.lnNewton(root, scale);
        return BigDecimal.valueOf(magnitude).multiply(lnRoot).setScale(scale, 6);
    }

    public static BigDecimal nvl(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public static BigDecimal pow(BigDecimal x, int scale, BigDecimal exponent) {
        BigDecimal lnX = BigDecimalHelper.ln(x, scale);
        BigDecimal newExponent = lnX.multiply(exponent);
        return BigDecimalHelper.exp(newExponent, scale);
    }

    @Deprecated
    public static BigDecimal simpleLn(BigDecimal x, int scale) {
        long unscaledValue = x.unscaledValue().longValue();
        int scalevalue = x.scale();
        double result = Math.log(unscaledValue) - (double)scalevalue * Math.log(10.0);
        return new BigDecimal(result, new MathContext(scale));
    }

    public static BigDecimal sqrt(BigDecimal x, int scale) {
        BigInteger ixPrev;
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        BigInteger n = x.movePointRight(scale << 1).toBigInteger();
        int bits = n.bitLength() + 1 >> 1;
        BigInteger ix = n.shiftRight(bits);
        do {
            ixPrev = ix;
            ix = ix.add(n.divide(ix)).shiftRight(1);
            Thread.yield();
        } while (ix.compareTo(ixPrev) != 0);
        return new BigDecimal(ix, scale);
    }

    private static BigDecimal arctanTaylor(BigDecimal x, int scale) {
        BigDecimal term;
        int sp1 = scale + 1;
        int i = 3;
        boolean addFlag = false;
        BigDecimal power = x;
        BigDecimal sum = x;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        do {
            power = power.multiply(x).multiply(x).setScale(sp1, 6);
            term = power.divide(BigDecimal.valueOf(i), sp1, 6);
            sum = addFlag ? sum.add(term) : sum.subtract(term);
            i += 2;
            addFlag = !addFlag;
            Thread.yield();
        } while (term.compareTo(tolerance) > 0);
        return sum;
    }

    private static BigDecimal expTaylor(BigDecimal x, int scale) {
        BigDecimal sumPrev;
        BigDecimal factorial = BigDecimal.valueOf(1L);
        BigDecimal xPower = x;
        BigDecimal sum = x.add(BigDecimal.valueOf(1L));
        int i = 2;
        do {
            xPower = xPower.multiply(x).setScale(scale, 6);
            factorial = factorial.multiply(BigDecimal.valueOf(i));
            BigDecimal term = xPower.divide(factorial, scale, 6);
            sumPrev = sum;
            sum = sum.add(term);
            ++i;
            Thread.yield();
        } while (sum.compareTo(sumPrev) != 0);
        return sum;
    }

    private static BigDecimal lnNewton(BigDecimal x, int scale) {
        BigDecimal term;
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        do {
            BigDecimal eToX = BigDecimalHelper.exp(x, sp1);
            term = eToX.subtract(n).divide(eToX, sp1, 1);
            x = x.subtract(term);
            Thread.yield();
        } while (term.compareTo(tolerance) > 0);
        return x.setScale(scale, 6);
    }
}

