/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import com.google.code.kaptcha.GimpyEngine;
import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.text.WordRenderer;
import com.google.code.kaptcha.util.Config;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.CyclosConfiguration;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import nl.strohalm.cyclos.utils.customizedfile.ImageChangeListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class CaptchaProducer
implements Producer,
ServletContextAware,
InitializingBean {
    private BufferedImage background;
    private WordRenderer wordRenderer;
    private GimpyEngine gimpyEngine;
    private Config config;
    private ServletContext servletContext;
    private CustomizedFileHandler customizedFileHandler;

    public void afterPropertiesSet() throws Exception {
        this.config = new Config(CyclosConfiguration.getCyclosProperties());
        this.wordRenderer = this.config.getWordRendererImpl();
        this.gimpyEngine = this.config.getObscurificatorImpl();
        this.customizedFileHandler.addImageChangeListener(new ImageChangeListener(){

            @Override
            public void onImageChanged(nl.strohalm.cyclos.entities.customization.images.Image image) {
                if (image.getNature() == Image.Nature.SYSTEM && image.getName().contains("captchaBackground")) {
                    CaptchaProducer.this.background = null;
                }
            }
        });
    }

    public BufferedImage createImage(String text) {
        BufferedImage background = this.readBackground();
        BufferedImage image = this.wordRenderer.renderWord(text, background.getWidth(), background.getHeight());
        image = this.gimpyEngine.getDistortedImage(image);
        return this.combine(image, background);
    }

    public String createText() {
        return this.config.getTextProducerImpl().getText();
    }

    public void setCustomizedFileHandler(CustomizedFileHandler customizedFileHandler) {
        this.customizedFileHandler = customizedFileHandler;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private BufferedImage combine(BufferedImage image, BufferedImage background) {
        int width = background.getWidth();
        int height = background.getHeight();
        BufferedImage imageWithBackground = new BufferedImage(width, height, 2);
        Graphics2D graph = (Graphics2D)imageWithBackground.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graph.setRenderingHints(hints);
        graph.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        graph.drawImage((Image)background, 0, 0, null);
        graph.drawImage((Image)image, 0, 0, null);
        return imageWithBackground;
    }

    private BufferedImage readBackground() {
        if (this.background == null) {
            try {
                URL backgroundUrl = this.servletContext.getResource("/pages/images/captchaBackground.jpg");
                this.background = ImageIO.read(backgroundUrl);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not read captcha background image");
            }
        }
        return this.background;
    }
}

