/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import nl.strohalm.cyclos.utils.binding.BindingException;
import org.apache.commons.lang.ClassUtils;

public final class ClassHelper {
    public static List<Class<?>> allImplementedTypes(Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        ArrayList classes = new ArrayList(interfaces.length + 1);
        while (clazz != null && !clazz.equals(Object.class)) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        classes.addAll(Arrays.asList(interfaces));
        return classes;
    }

    public static <T> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, C extends T> Class<C> concreteClass(Class<T> clazz) {
        void var1_9;
        if (clazz == null) {
            throw new NullPointerException("null.clazz");
        }
        Object var1_1 = null;
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || Collection.class.isAssignableFrom(clazz)) {
            if (Calendar.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (!Map.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Unknown concrete class for " + clazz.getName());
            return var1_9;
        }
        Class<T> clazz2 = clazz;
        return var1_9;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> type) {
        List<Class<?>> classes = ClassHelper.allImplementedTypes(clazz);
        for (Class<?> c : classes) {
            try {
                A annotation = c.getAnnotation(type);
                if (annotation == null) continue;
                return annotation;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> type) {
        return ClassHelper.findAnnotation(method, type, false);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> type, boolean searchInDeclaringClass) {
        Class<?> declaringClass = method.getDeclaringClass();
        List<Class<?>> classes = ClassHelper.allImplementedTypes(declaringClass);
        for (Class<?> c : classes) {
            try {
                Method m = c.getMethod(method.getName(), method.getParameterTypes());
                A annotation = m.getAnnotation(type);
                if (annotation == null) continue;
                return annotation;
            }
            catch (Exception e) {
            }
        }
        if (searchInDeclaringClass) {
            return ClassHelper.findAnnotation(method.getDeclaringClass(), type);
        }
        return null;
    }

    public static String getClassName(Class<?> clazz) {
        String name = clazz.getName();
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            Object object = ClassHelper.concreteClass(clazz).newInstance();
            return (T)object;
        }
        catch (Exception e) {
            throw new BindingException("Could not instantiate bean of class " + clazz.getName(), e);
        }
    }

    public static boolean isInstance(Class<?> clazz, Object object) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.primitiveToWrapper(clazz);
        }
        return clazz.isInstance(object);
    }
}

