/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CombinedIterator<C, M, I, K>
implements Iterator<C> {
    private Iterator<M> masterIterator;
    private Map<K, Iterator<I>> innerIterators;
    private Map<K, I> currentElements;
    private Map<K, I> innerElements;

    public CombinedIterator(Iterator<M> masterIterator) {
        this.masterIterator = masterIterator;
        this.innerElements = new HashMap<K, I>();
    }

    @Override
    public boolean hasNext() {
        if (this.innerIterators == null) {
            this.innerIterators = new LinkedHashMap<K, Iterator<I>>();
            this.registerInnerIterators();
        }
        return this.masterIterator.hasNext();
    }

    @Override
    public C next() {
        M masterElement = this.masterIterator.next();
        if (this.currentElements == null) {
            this.readCurrentElements();
        }
        this.innerElements.clear();
        for (Map.Entry<K, I> entry : this.currentElements.entrySet()) {
            I value;
            K key = entry.getKey();
            if (!this.belongsToMasterElement(masterElement, key, value = entry.getValue())) continue;
            this.innerElements.put(key, value);
            this.advanceIterator(key);
        }
        return this.combine(masterElement, this.innerElements);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean belongsToMasterElement(M var1, K var2, I var3);

    protected abstract C combine(M var1, Map<K, I> var2);

    protected void registerInnerIterator(K key, Iterator<I> iterator) {
        this.innerIterators.put(key, iterator);
    }

    protected abstract void registerInnerIterators();

    private I advanceIterator(K key) {
        Iterator<I> iterator = this.innerIterators.get(key);
        if (iterator.hasNext()) {
            I element = iterator.next();
            this.currentElements.put(key, element);
            return element;
        }
        this.currentElements.remove(key);
        return null;
    }

    private void readCurrentElements() {
        if (this.currentElements == null) {
            this.currentElements = new ConcurrentHashMap<K, I>();
        }
        for (K key : this.innerIterators.keySet()) {
            I element = this.advanceIterator(key);
            if (element == null) {
                this.currentElements.remove(key);
                continue;
            }
            this.currentElements.put(key, element);
        }
    }
}

