/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.DatatypeConverter;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.webservices.model.FieldValueVO;
import nl.strohalm.cyclos.webservices.model.RegistrationFieldValueVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public final class CustomFieldHelper {
    private SettingsService settingsService;
    private ElementService elementService;

    public List<AdCustomField> adFieldsForSearch(List<AdCustomField> fields) {
        ArrayList<AdCustomField> adFields = new ArrayList<AdCustomField>();
        for (AdCustomField field : fields) {
            if (!field.isShowInSearch()) continue;
            adFields.add(field);
        }
        return adFields;
    }

    public Collection<Entry> buildEntries(Collection<? extends CustomField> fields, Collection<? extends CustomFieldValue> values) {
        if (fields == null) {
            return null;
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(fields.size());
        for (CustomField customField : fields) {
            CustomFieldValue fieldValue = this.findByField(customField, values);
            if (fieldValue != null) {
                if (customField.getType() == CustomField.Type.MEMBER) {
                    Long id = IdConverter.instance().valueOf(fieldValue.getValue());
                    if (id != null) {
                        fieldValue.setMemberValue(this.loadMember(id));
                    }
                } else if (StringUtils.isNotEmpty((String)customField.getPattern())) {
                    fieldValue.setValue(StringHelper.removeMask(customField.getPattern(), fieldValue.getValue()));
                }
            }
            entries.add(new Entry(customField, fieldValue));
        }
        return entries;
    }

    public <V extends CustomFieldValue> Collection<V> buildValues(Class<V> valueClass, Collection<? extends CustomField> fields, Map<String, String> values) {
        if (valueClass != null && fields != null && values != null) {
            ArrayList<CustomFieldValue> fieldValues = new ArrayList<CustomFieldValue>();
            for (CustomField customField : fields) {
                String value = values.get(customField.getInternalName());
                CustomFieldValue fieldValue = (CustomFieldValue)ClassHelper.instantiate(valueClass);
                fieldValue.setField(customField);
                if (StringUtils.isNotEmpty((String)value)) {
                    CustomField.Type type = customField.getType();
                    if (type == CustomField.Type.ENUMERATED) {
                        fieldValue.setPossibleValue(this.findPossibleValue(value, customField.getPossibleValues(false)));
                    } else if (type == CustomField.Type.MEMBER) {
                        fieldValue.setMemberValue(this.loadMember(IdConverter.instance().valueOf(value)));
                    } else {
                        fieldValue.setStringValue(value);
                    }
                }
                fieldValues.add(fieldValue);
            }
            return fieldValues;
        }
        return null;
    }

    public <CF extends CustomField, CFV extends CustomFieldValue> void cloneFieldValues(CustomFieldsContainer<CF, CFV> from, CustomFieldsContainer<CF, CFV> to) {
        this.cloneFieldValues(from, to, false);
    }

    public <CF extends CustomField, CFV extends CustomFieldValue> void cloneFieldValues(CustomFieldsContainer<CF, CFV> from, CustomFieldsContainer<CF, CFV> to, boolean resetOwner) {
        ArrayList<CustomFieldValue> newCustomValues = new ArrayList<CustomFieldValue>();
        Collection<CFV> customValues = from.getCustomValues();
        if (customValues != null) {
            for (CustomFieldValue customValue : customValues) {
                Object clone = customValue.clone();
                CustomFieldValue newCustomValue = (CustomFieldValue)clone;
                if (resetOwner) {
                    newCustomValue.setOwner(null);
                } else {
                    newCustomValue.setOwner(to);
                }
                newCustomValue.setId(null);
                newCustomValues.add(newCustomValue);
            }
        }
        to.setCustomValues(newCustomValues);
    }

    public <V extends CustomFieldValue> V findByField(CustomField field, Collection<V> values) {
        if (values != null && field != null) {
            for (CustomFieldValue value : values) {
                if (!field.equals(value.getField())) continue;
                return (V)value;
            }
        }
        return null;
    }

    public <V extends CustomFieldValue> V findByFieldId(Long fieldId, Collection<V> values) {
        if (values != null && fieldId != null) {
            for (CustomFieldValue value : values) {
                if (!value.getField().getId().equals(fieldId)) continue;
                return (V)value;
            }
        }
        return null;
    }

    public <V extends CustomFieldValue> V findByFieldName(String fieldName, Collection<V> values) {
        if (values != null && StringUtils.isNotEmpty((String)fieldName)) {
            for (CustomFieldValue value : values) {
                if (!value.getField().getInternalName().equals(fieldName)) continue;
                return (V)value;
            }
        }
        return null;
    }

    public <F extends CustomField> F findById(Collection<F> fields, Long id) {
        if (fields != null && id != null) {
            for (CustomField f : fields) {
                if (!ObjectUtils.equals((Object)f.getId(), (Object)id)) continue;
                return (F)f;
            }
        }
        return null;
    }

    public <F extends CustomField> F findByIdOrInternalName(Collection<F> fields, Long id, String internalName) {
        F result = null;
        result = this.findById(fields, id);
        if (result == null) {
            result = this.findByInternalName(fields, internalName);
        }
        return result;
    }

    public <F extends CustomField> F findByInternalName(Collection<F> fields, String internalName) {
        if (fields != null && internalName != null) {
            for (CustomField f : fields) {
                if (!ObjectUtils.equals((Object)f.getInternalName(), (Object)internalName)) continue;
                return (F)f;
            }
        }
        return null;
    }

    public CustomFieldPossibleValue findPossibleValue(String value, Collection<CustomFieldPossibleValue> possibleValues) {
        if (StringUtils.isNotEmpty((String)value)) {
            for (CustomFieldPossibleValue possibleValue : possibleValues) {
                if (!value.equals(possibleValue.getValue())) continue;
                return possibleValue;
            }
        }
        return null;
    }

    public CustomFieldPossibleValue findPossibleValueById(Long id, Collection<CustomFieldPossibleValue> possibleValues) {
        if (EntityHelper.isValidId(id) && CollectionUtils.isNotEmpty(possibleValues)) {
            for (CustomFieldPossibleValue possibleValue : possibleValues) {
                if (!id.equals(possibleValue.getId())) continue;
                return possibleValue;
            }
        }
        return null;
    }

    public String findPossibleValueById(Object value, Collection<CustomFieldPossibleValue> possibleValues) {
        try {
            long id = CoercionHelper.coerce(Long.TYPE, value);
            for (CustomFieldPossibleValue possibleValue : possibleValues) {
                if (id != possibleValue.getId()) continue;
                return possibleValue.getValue();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public Map<String, String> getFields(CustomFieldsContainer<?, ?> container) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (CustomFieldValue value : container.getCustomValues()) {
            values.put(value.getField().getInternalName(), value.getValue());
        }
        return values;
    }

    public <FV extends CustomFieldValue> FV getValue(String internalName, Collection<FV> customValues) {
        for (CustomFieldValue value : customValues) {
            if (!value.getField().getInternalName().equals(internalName)) continue;
            return (FV)value;
        }
        return null;
    }

    public <CF extends CustomField, CFV extends CustomFieldValue> Map<CF, CFV> getValuesByField(CustomFieldsContainer<CF, CFV> container) {
        LinkedHashMap<CustomField, CustomFieldValue> values = new LinkedHashMap<CustomField, CustomFieldValue>();
        for (CustomFieldValue value : container.getCustomValues()) {
            values.put(value.getField(), value);
        }
        return values;
    }

    public <T extends CustomFieldValue> Collection<T> mergeFieldValues(CustomFieldsContainer<?, T> customFieldContainer, List<? extends FieldValueVO> pFieldValueVOs, List<? extends CustomField> allowedFields) {
        Collection<T> newFieldValues;
        ArrayList<T> currentFieldValues = new ArrayList<T>(customFieldContainer.getCustomValues());
        ArrayList<FieldValueVO> fieldValueVOs = null;
        if (pFieldValueVOs != null) {
            fieldValueVOs = new ArrayList<FieldValueVO>();
            for (FieldValueVO fieldValueVO : pFieldValueVOs) {
                fieldValueVOs.add((FieldValueVO)fieldValueVO.clone());
            }
            for (FieldValueVO fieldValueVO : fieldValueVOs) {
                MemberCustomFieldValue cfv;
                CustomField cf;
                RegistrationFieldValueVO rfv;
                T cfv2;
                CustomField cf2;
                if (fieldValueVO.getValue() == null && fieldValueVO.getPossibleValueId() == null && (cf2 = this.findByIdOrInternalName(allowedFields, fieldValueVO.getFieldId(), fieldValueVO.getInternalName())) != null && (cfv2 = this.getValue(cf2.getInternalName(), currentFieldValues)) != null) {
                    fieldValueVO.setValue(((CustomFieldValue)cfv2).getValue());
                    if (((CustomFieldValue)cfv2).getPossibleValue() != null) {
                        fieldValueVO.setPossibleValueId(((CustomFieldValue)cfv2).getPossibleValue().getId());
                    }
                    if (((CustomFieldValue)cfv2).getMemberValue() != null) {
                        fieldValueVO.setMemberValueId(((CustomFieldValue)cfv2).getMemberValue().getId());
                    }
                }
                if (!(fieldValueVO instanceof RegistrationFieldValueVO) || (rfv = (RegistrationFieldValueVO)fieldValueVO).getHidden() != null || (cf = this.findByIdOrInternalName(allowedFields, rfv.getFieldId(), rfv.getInternalName())) == null || (cfv = (MemberCustomFieldValue)this.getValue(cf.getInternalName(), currentFieldValues)) == null) continue;
                rfv.setHidden(cfv.isHidden());
            }
        }
        if (CollectionUtils.isEmpty(newFieldValues = this.toValueCollection(allowedFields, fieldValueVOs))) {
            return currentFieldValues;
        }
        for (CustomFieldValue cv : currentFieldValues) {
            boolean modifiedFieldValue;
            if (!allowedFields.contains(cv.getField()) || (modifiedFieldValue = this.getValue(cv.getField().getInternalName(), newFieldValues) != null)) continue;
            newFieldValues.add(cv);
        }
        return newFieldValues;
    }

    public <T extends CustomField> List<T> onlyBasic(List<T> customFields) {
        ArrayList<CustomField> result = new ArrayList<CustomField>(customFields.size());
        for (CustomField field : customFields) {
            CustomField.Type type = field.getType();
            CustomField.Control control = field.getControl();
            boolean useField = false;
            if (type == CustomField.Type.STRING && control == CustomField.Control.TEXT) {
                useField = true;
            } else if (type == CustomField.Type.ENUMERATED || type == CustomField.Type.INTEGER) {
                useField = true;
            }
            if (!useField) continue;
            result.add(field);
        }
        return result;
    }

    public List<MemberCustomField> onlyForAdSearch(List<MemberCustomField> fields) {
        ArrayList<MemberCustomField> memberFields = new ArrayList<MemberCustomField>();
        boolean unrestricted = LoggedUser.isSystemOrUnrestrictedClient();
        Group group = unrestricted ? null : (Group)LoggedUser.group();
        for (MemberCustomField field : fields) {
            MemberCustomField.Access access = field.getAdSearchAccess();
            if (!unrestricted && (access == null || !access.granted(group, true, LoggedUser.isBroker(), false, LoggedUser.isWebService()))) continue;
            memberFields.add(field);
        }
        return memberFields;
    }

    public List<AdCustomField> onlyForAdsSearch(List<AdCustomField> fields) {
        Group.Nature nature = LoggedUser.hasUser() ? ((Group)LoggedUser.group()).getNature() : Group.Nature.MEMBER;
        ArrayList<AdCustomField> adFields = new ArrayList<AdCustomField>();
        for (AdCustomField field : fields) {
            AdCustomField.Visibility visibility = field.getVisibility();
            if (!visibility.granted(nature) && (!LoggedUser.isWebService() || visibility != AdCustomField.Visibility.WEB_SERVICE)) continue;
            adFields.add(field);
        }
        return adFields;
    }

    public List<AdminCustomField> onlyForGroup(List<AdminCustomField> fields, AdminGroup group) {
        ArrayList<AdminCustomField> adminFields = new ArrayList<AdminCustomField>();
        for (AdminCustomField field : fields) {
            if (!field.getGroups().contains(group)) continue;
            adminFields.add(field);
        }
        return adminFields;
    }

    public List<MemberCustomField> onlyForGroup(List<MemberCustomField> fields, MemberGroup group) {
        ArrayList<MemberCustomField> memberFields = new ArrayList<MemberCustomField>(fields.size());
        for (MemberCustomField field : fields) {
            if (!field.getGroups().contains(group)) continue;
            memberFields.add(field);
        }
        return memberFields;
    }

    public List<MemberCustomField> onlyForGroups(List<MemberCustomField> fields, Collection<MemberGroup> groups) {
        HashSet<MemberCustomField> memberFields = new HashSet<MemberCustomField>();
        for (MemberGroup group : groups) {
            memberFields.addAll(this.onlyForGroup(fields, group));
        }
        return new ArrayList<MemberCustomField>(memberFields);
    }

    public List<MemberCustomField> onlyForLoanSearch(List<MemberCustomField> fields) {
        ArrayList<MemberCustomField> memberFields = new ArrayList<MemberCustomField>();
        Object group = LoggedUser.group();
        for (MemberCustomField field : fields) {
            MemberCustomField.Access access = field.getLoanSearchAccess();
            if (access == null || !access.granted((Group)group, true, false, false, false)) continue;
            memberFields.add(field);
        }
        return memberFields;
    }

    public List<MemberCustomField> onlyForMemberSearch(List<MemberCustomField> fields) {
        ArrayList<MemberCustomField> memberFields = new ArrayList<MemberCustomField>(fields.size());
        if (LoggedUser.isSystemOrUnrestrictedClient()) {
            memberFields.addAll(fields);
            return memberFields;
        }
        Object group = LoggedUser.group();
        for (MemberCustomField field : fields) {
            MemberCustomField.Access access = field.getMemberSearchAccess();
            if (access == null || !access.granted((Group)group, true, LoggedUser.isBroker(), false, LoggedUser.isWebService())) continue;
            memberFields.add(field);
        }
        return memberFields;
    }

    public List<MemberCustomField> onlyInAllGroups(List<MemberCustomField> fields, Collection<MemberGroup> groups) {
        HashSet<MemberCustomField> memberFields = new HashSet<MemberCustomField>();
        for (MemberCustomField f : fields) {
            if (!f.getGroups().containsAll(groups)) continue;
            memberFields.add(f);
        }
        return new ArrayList<MemberCustomField>(memberFields);
    }

    public List<MemberCustomField> onlyOwnedFields(List<MemberCustomField> fields, MemberGroup group) {
        return this.doListVisibleFields(fields, group, true);
    }

    public List<MemberCustomField> onlyVisibleFields(List<MemberCustomField> fields, MemberGroup group) {
        return this.doListVisibleFields(fields, group, false);
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public <T extends CustomFieldValue> Collection<T> toValueCollection(Collection<? extends CustomField> fields, List<? extends FieldValueVO> fieldValues) {
        if (CollectionUtils.isEmpty(fields) || CollectionUtils.isEmpty(fieldValues)) {
            return Collections.emptySet();
        }
        ArrayList<CustomFieldValue> customValues = new ArrayList<CustomFieldValue>();
        for (FieldValueVO fieldValueVO : fieldValues) {
            CustomField field = this.findByIdOrInternalName(fields, fieldValueVO.getFieldId(), fieldValueVO.getInternalName());
            if (field == null) {
                throw new IllegalArgumentException("Couldn't find custom field for this field: " + fieldValueVO);
            }
            CustomFieldValue value = ClassHelper.instantiate(field.getNature().getValueType());
            value.setField(field);
            if (field.getType() == CustomField.Type.ENUMERATED) {
                if (EntityHelper.isValidId(fieldValueVO.getPossibleValueId())) {
                    CustomFieldPossibleValue possibleValue = this.findPossibleValueById(fieldValueVO.getPossibleValueId(), field.getPossibleValues(true));
                    if (possibleValue == null) {
                        throw new IllegalArgumentException("Expected one of this values: " + field.getPossibleValues(true) + " for field: " + field);
                    }
                    value.setPossibleValue(possibleValue);
                } else {
                    String[] parts;
                    HashSet<Long> possibleValueIds = new HashSet<Long>();
                    for (String part : parts = StringUtils.split((String)fieldValueVO.getValue(), (char)',')) {
                        if ((part = StringUtils.trimToNull((String)part)) == null) continue;
                        CustomFieldPossibleValue possibleValue = EntityHelper.isValidId(fieldValueVO.getValue()) ? this.findPossibleValueById(Long.parseLong(part), field.getPossibleValues(true)) : this.findPossibleValue(part, field.getPossibleValues(true));
                        if (possibleValue == null) {
                            throw new IllegalArgumentException("Expected one of this values: " + field.getPossibleValues(true) + " for field: " + field);
                        }
                        possibleValueIds.add(possibleValue.getId());
                    }
                    value.setValue(StringUtils.join(possibleValueIds.iterator(), (char)','));
                }
            } else if (field.getType() == CustomField.Type.MEMBER) {
                Member memberValue = null;
                Long memberValueId = fieldValueVO.getMemberValueId();
                boolean setMember = false;
                if (EntityHelper.isValidId(memberValueId)) {
                    memberValue = this.loadMember(memberValueId);
                    setMember = true;
                } else if (!StringUtils.isEmpty((String)fieldValueVO.getValue())) {
                    memberValue = this.loadMember(fieldValueVO.getValue());
                    setMember = true;
                }
                if (setMember && memberValue == null) {
                    throw new EntityNotFoundException(Member.class);
                }
                value.setMemberValue(memberValue);
            } else {
                Calendar parsedDateTime = null;
                if (field.getType() == CustomField.Type.DATE) {
                    parsedDateTime = this.parseISO8601Date(fieldValueVO.getValue());
                }
                if (parsedDateTime != null) {
                    LocalSettings localSettings = this.settingsService.getLocalSettings();
                    value.setValue(localSettings.getDateConverter().toString(parsedDateTime));
                } else {
                    value.setValue(fieldValueVO.getValue());
                }
                if (StringUtils.isNotEmpty((String)field.getPattern())) {
                    value.setValue(StringHelper.removeMask(field.getPattern(), value.getValue()));
                }
            }
            if (fieldValueVO instanceof RegistrationFieldValueVO && value instanceof MemberCustomFieldValue) {
                RegistrationFieldValueVO reg = (RegistrationFieldValueVO)fieldValueVO;
                MemberCustomFieldValue memberValue = (MemberCustomFieldValue)value;
                memberValue.setHidden(reg.getHidden() == null ? Boolean.FALSE : reg.getHidden());
            }
            customValues.add(value);
        }
        return customValues;
    }

    private List<MemberCustomField> doListVisibleFields(List<MemberCustomField> fields, MemberGroup group, boolean byOwner) {
        fields = this.onlyForGroup(fields, group);
        Iterator<MemberCustomField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            MemberCustomField field = iterator.next();
            if (field.getVisibilityAccess().granted(group, byOwner, false, false, LoggedUser.isWebService())) continue;
            iterator.remove();
        }
        return fields;
    }

    private Member loadMember(final Long id) {
        try {
            return LoggedUser.runAsSystem(new Callable<Member>(){

                @Override
                public Member call() throws Exception {
                    return (Member)CustomFieldHelper.this.elementService.load(id, Element.Relationships.GROUP);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    private Member loadMember(String username) {
        try {
            return (Member)((User)this.elementService.loadUser(username, new Relationship[0])).getElement();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Calendar parseISO8601Date(String date) {
        try {
            return DatatypeConverter.parseDateTime((String)date);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public class Entry
    implements Serializable {
        private static final long serialVersionUID = 1629234603383130863L;
        private final CustomField field;
        private final CustomFieldValue value;

        public Entry(CustomField field, CustomFieldValue value) {
            this.field = field;
            this.value = value;
        }

        public CustomField getField() {
            return this.field;
        }

        public CustomFieldValue getValue() {
            return this.value;
        }

        public String toString() {
            String value;
            String field;
            try {
                field = this.field.getName();
            }
            catch (NullPointerException e) {
                field = "null";
            }
            try {
                value = this.value.getValue();
            }
            catch (NullPointerException e) {
                value = "null";
            }
            return field + "=" + value;
        }
    }
}

