/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.strohalm.cyclos.utils.CustomObjectHandler;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CustomObjectHandlerImpl
implements CustomObjectHandler,
ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private final Map<String, Object> beans = new ConcurrentHashMap<String, Object>();

    @Override
    public boolean contains(String className) {
        return this.beans.containsKey(className);
    }

    public void destroy() throws Exception {
        for (Object object : this.beans.values()) {
            if (!(object instanceof DisposableBean)) continue;
            ((DisposableBean)object).destroy();
        }
        this.beans.clear();
    }

    @Override
    public <T> T get(String className) {
        Object bean = this.beans.get(className);
        if (bean == null) {
            bean = this.doGet(className);
        }
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> beanType) {
        return (T)this.applicationContext.getBean(beanType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private synchronized Object doGet(String className) {
        Object bean = this.beans.get(className);
        if (bean != null) {
            return bean;
        }
        try {
            AutowireCapableBeanFactory factory = this.applicationContext.getAutowireCapableBeanFactory();
            Class<?> beanClass = Class.forName(className);
            bean = factory.createBean(beanClass, 2, false);
            factory.initializeBean(bean, beanClass.getSimpleName() + "#" + System.identityHashCode(bean));
            this.beans.put(className, bean);
            return bean;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't instantiate class " + className, e);
        }
    }
}

