/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.binaryfiles.BinaryFile;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class CustomizationHelper
implements ServletContextAware {
    public static List<String> OPERATOR_SPECIFIC_FILES = Collections.unmodifiableList(Arrays.asList("posweb_header.jsp", "posweb_footer.jsp"));
    public static final String APPLICATION_PAGES_PATH = "/pages/";
    public static final String STATIC_FILES_PATH = "/pages/general/static_files/";
    public static final String STYLE_PATH = "/pages/styles/";
    public static final String HELP_PATH = "/pages/general/translation_files/helps/";
    public static final String DOCUMENT_PATH = "/pages/documents/";
    private static final List<String> EXCLUDED_DIRS = Arrays.asList("/general/translation_files/", "/scripts/", "/styles/");
    private static final List<String> LOGIN_CUSTOMIZED_FILES = Arrays.asList("login.css", "login.jsp", "top.jsp");
    private GroupService groupService;
    private SettingsService settingsService;
    private CustomizedFileHandler customizedFileHandler;
    private ServletContext context;

    public File customizedFileOf(CustomizedFile file) {
        String customizedPath;
        Group group = file.getGroup();
        GroupFilter groupFilter = file.getGroupFilter();
        CustomizedFile.Type type = file.getType();
        if (group == null && groupFilter == null) {
            customizedPath = this.customizedPathFor(type);
        } else if (group != null) {
            boolean forceSameGroup = (group = this.loadGroup(group.getId(), new Relationship[0])) instanceof OperatorGroup && OPERATOR_SPECIFIC_FILES.contains(file.getName());
            customizedPath = this.customizedPathFor(type, group, forceSameGroup);
        } else {
            customizedPath = this.customizedPathFor(type, groupFilter);
        }
        File dir = new File(this.context.getRealPath(customizedPath));
        String fileName = this.resolveName(file);
        return new File(dir, fileName);
    }

    public File customizedFileOf(CustomizedFile.Type type, String name) {
        CustomizedFile file = new CustomizedFile();
        file.setType(type);
        file.setName(name);
        return this.customizedFileOf(file);
    }

    public String customizedPathFor(CustomizedFile.Type type) {
        String path;
        switch (type) {
            case STATIC_FILE: {
                path = "/pages/general/static_files/customized/";
                break;
            }
            case HELP: {
                path = HELP_PATH;
                break;
            }
            case STYLE: {
                path = STYLE_PATH;
                break;
            }
            case APPLICATION_PAGE: {
                path = APPLICATION_PAGES_PATH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown file type: " + type);
            }
        }
        return path;
    }

    public String customizedPathFor(CustomizedFile.Type type, Group group, boolean forceSameGroup) {
        if (group != null && type != CustomizedFile.Type.STYLE) {
            String pathPart = this.pathPart(group, forceSameGroup);
            return this.customizedPathFor(type) + pathPart + "/";
        }
        return this.customizedPathFor(type);
    }

    public String customizedPathFor(CustomizedFile.Type type, GroupFilter groupFilter) {
        if (groupFilter != null && type != CustomizedFile.Type.STYLE) {
            String pathPart = this.pathPart(groupFilter);
            return this.customizedPathFor(type) + pathPart + "/";
        }
        return this.customizedPathFor(type);
    }

    public void deleteFile(File file) {
        this.customizedFileHandler.delete(this.getRelativePath(file));
    }

    public File documentDir() {
        return new File(this.context.getRealPath(DOCUMENT_PATH));
    }

    public File documentFile(DynamicDocument document) {
        return new File(this.documentDir(), "document_" + document.getId() + ".jsp");
    }

    public CustomizationData findCustomizationOf(CustomizedFile.Type type, Group group, GroupFilter groupFilter, String name) {
        String globallyCustomizedPath;
        File physicalFile;
        CustomizedFile file = new CustomizedFile();
        file.setType(type);
        file.setName(name);
        if (group == null && LoggedUser.hasUser()) {
            group = LoggedUser.group();
        }
        if (group != null) {
            group = this.loadGroup(group.getId(), new Relationship[0]);
            file.setGroup(group);
            String customizedPath = this.customizedPathFor(type, group, true);
            String dir = this.context.getRealPath(customizedPath);
            String fileName = this.resolveName(file);
            File physicalFile2 = new File(dir, fileName);
            if (physicalFile2.exists()) {
                if (type == CustomizedFile.Type.STYLE && group instanceof OperatorGroup) {
                    group = ((OperatorGroup)group).getMember().getGroup();
                }
                return new CustomizationData(CustomizationLevel.GROUP, group.getId());
            }
            try {
                if (group instanceof OperatorGroup && (physicalFile2 = new File(dir = this.context.getRealPath(customizedPath = this.customizedPathFor(type, group, false)), fileName = this.resolveName(file))).exists()) {
                    String groupIdPart = "group_" + group.getId();
                    if (!fileName.contains(groupIdPart) && !dir.contains(groupIdPart)) {
                        group = ((OperatorGroup)group).getMember().getGroup();
                    }
                    return new CustomizationData(CustomizationLevel.GROUP, group.getId());
                }
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
            if (!LoggedUser.hasUser() || ((Entity)LoggedUser.group()).equals(group)) {
                file.setGroup(null);
                try {
                    Group groupForFilters = group;
                    if (group instanceof OperatorGroup) {
                        groupForFilters = ((OperatorGroup)group).getMember().getGroup();
                    }
                    Collection<GroupFilter> groupFilters = this.loadGroup(groupForFilters.getId(), Group.Relationships.GROUP_FILTERS).getGroupFilters();
                    for (GroupFilter current : groupFilters) {
                        file.setGroupFilter(current);
                        customizedPath = this.customizedPathFor(type, current);
                        dir = this.context.getRealPath(customizedPath);
                        physicalFile2 = new File(dir, fileName = this.resolveName(file));
                        if (!physicalFile2.exists()) continue;
                        return new CustomizationData(CustomizationLevel.GROUP_FILTER, current.getId());
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if (groupFilter != null) {
            file.setGroupFilter(groupFilter);
            File groupFilterFile = this.customizedFileOf(file);
            if (groupFilterFile.exists()) {
                return new CustomizationData(CustomizationLevel.GROUP_FILTER, groupFilter.getId());
            }
        }
        if ((physicalFile = new File(this.context.getRealPath(globallyCustomizedPath = this.customizedPathFor(type) + name))).exists()) {
            return new CustomizationData(CustomizationLevel.GLOBAL);
        }
        return new CustomizationData(CustomizationLevel.NONE);
    }

    public File findFileOf(CustomizedFile.Type type, Group group, GroupFilter groupFilter, String name) {
        String path = this.findPathOf(type, group, groupFilter, name);
        return new File(this.context.getRealPath(path));
    }

    public File findFileOf(CustomizedFile.Type type, Group group, String name) {
        return this.findFileOf(type, group, null, name);
    }

    public String findPathOf(CustomizedFile.Type type, Group group, String name) {
        return this.findPathOf(type, group, null, name);
    }

    public String findPathOf(CustomizedFile.Type type, Group group, GroupFilter groupFilter, String name) {
        CustomizationData customization = this.findCustomizationOf(type, group, groupFilter, name);
        return this.pathOf(type, name, customization);
    }

    public File formFile(DynamicDocument document) {
        return new File(this.documentDir(), "form_" + document.getId() + ".jsp");
    }

    public List<File> getDirectoryContents(String path) {
        String rootPath = APPLICATION_PAGES_PATH + ("/".equals(path) ? "" : path);
        File rootDir = new File(this.context.getRealPath(rootPath));
        List<File> allDirectories = Arrays.asList(rootDir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY));
        ArrayList<File> filteredDirectories = new ArrayList<File>();
        for (File currentFile : allDirectories) {
            String fullPath = path + currentFile.getName() + "/";
            if (EXCLUDED_DIRS.contains(fullPath)) continue;
            filteredDirectories.add(currentFile);
        }
        List<File> files = Arrays.asList(rootDir.listFiles(CustomizedFile.Type.APPLICATION_PAGE.getFilter()));
        Collections.sort(filteredDirectories);
        Collections.sort(files);
        ArrayList<File> filesAndDirs = new ArrayList<File>();
        filesAndDirs.addAll(filteredDirectories);
        filesAndDirs.addAll(files);
        return filesAndDirs;
    }

    public String getRelativePath(File file) {
        String root;
        String absolutePath = file.getAbsolutePath();
        if (absolutePath.startsWith(root = this.context.getRealPath("/"))) {
            return absolutePath.substring(root.length());
        }
        return absolutePath;
    }

    public boolean isAnyFileRelatedToLoginPage(Collection<CustomizedFile> files) {
        for (CustomizedFile file : files) {
            if (!this.isRelatedToLoginPage(file)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelatedToLoginPage(CustomizedFile file) {
        return LOGIN_CUSTOMIZED_FILES.contains(file.getName());
    }

    public List<File> listByType(CustomizedFile.Type type) {
        File dir = new File(this.context.getRealPath(this.originalPathFor(type)));
        return new ArrayList<File>(Arrays.asList(dir.listFiles(type.getFilter())));
    }

    public List<String> onlyNotAlreadyCustomized(CustomizedFile.Type type, List<CustomizedFile> customizedFiles) {
        ArrayList<String> notYetCustomized = new ArrayList<String>();
        List<File> files = this.listByType(type);
        CustomizedFileQuery query = new CustomizedFileQuery();
        query.setType(type);
        for (File file : files) {
            boolean alreadyCustomized = false;
            for (CustomizedFile customizedFile : customizedFiles) {
                if (!customizedFile.getName().equals(file.getName())) continue;
                alreadyCustomized = true;
                break;
            }
            if (alreadyCustomized) continue;
            notYetCustomized.add(file.getName());
        }
        Collections.sort(notYetCustomized);
        return notYetCustomized;
    }

    public File originalFileOf(CustomizedFile.Type type, String name) {
        File dir = new File(this.context.getRealPath(this.originalPathFor(type)));
        return new File(dir, name);
    }

    public String originalPathFor(CustomizedFile.Type type) {
        String path;
        switch (type) {
            case STATIC_FILE: {
                path = STATIC_FILES_PATH;
                break;
            }
            case HELP: {
                String locale = LocaleConverter.instance().toString(this.settingsService.getLocalSettings().getLocale());
                path = HELP_PATH + locale + "/";
                break;
            }
            case STYLE: {
                path = "/pages/styles/original/";
                break;
            }
            case APPLICATION_PAGE: {
                path = APPLICATION_PAGES_PATH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown file type: " + type);
            }
        }
        return path;
    }

    public String pathOf(CustomizedFile.Type type, String name, CustomizationData customization) {
        String path;
        CustomizedFile file = new CustomizedFile();
        file.setType(type);
        file.setName(name);
        switch (customization.getLevel()) {
            case NONE: {
                path = this.originalPathFor(type);
                break;
            }
            case GLOBAL: {
                path = this.customizedPathFor(type);
                break;
            }
            case GROUP: {
                Group group = EntityHelper.reference(Group.class, customization.getId());
                file.setGroup(group);
                path = this.customizedPathFor(type, group, true);
                break;
            }
            case GROUP_FILTER: {
                GroupFilter groupFilter = EntityHelper.reference(GroupFilter.class, customization.getId());
                file.setGroupFilter(groupFilter);
                path = this.customizedPathFor(type, groupFilter);
                break;
            }
            default: {
                return null;
            }
        }
        return path + this.resolveName(file);
    }

    public void setCustomizedFileHandler(CustomizedFileHandler customizedFileHandler) {
        this.customizedFileHandler = customizedFileHandler;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public File staticFile(StaticDocument document) {
        return new File(this.documentDir(), document.getId().toString());
    }

    public void updateBinaryFile(File file, BinaryFile binaryFile) {
        byte[] contents;
        try {
            contents = binaryFile.getContents().getBytes(1L, binaryFile.getSize());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Long lastModified = binaryFile.getLastModified() == null ? System.currentTimeMillis() : binaryFile.getLastModified().getTimeInMillis();
        this.customizedFileHandler.write(this.getRelativePath(file), lastModified, contents);
    }

    public void updateFile(File file, long lastModified, byte[] contents) {
        this.customizedFileHandler.write(this.getRelativePath(file), lastModified, contents);
    }

    public void updateFile(File file, long lastModified, String contentsStr) {
        byte[] contents;
        if (contentsStr == null) {
            contentsStr = "";
        }
        try {
            contents = contentsStr.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.updateFile(file, lastModified, contents);
    }

    public void updateFile(File file, nl.strohalm.cyclos.entities.customization.files.File customizedFile) {
        Long lastModified = customizedFile.getLastModified() == null ? System.currentTimeMillis() : customizedFile.getLastModified().getTimeInMillis();
        this.updateFile(file, (long)lastModified, customizedFile.getContents());
    }

    private Group loadGroup(final Long id, final Relationship ... relationships) {
        return LoggedUser.runAsSystem(new Callable<Group>(){

            @Override
            public Group call() throws Exception {
                return CustomizationHelper.this.groupService.load(id, relationships);
            }
        });
    }

    private String pathPart(Group group, boolean forceSameGroup) {
        Long groupId;
        if (group == null) {
            return null;
        }
        if (!forceSameGroup && group instanceof OperatorGroup) {
            OperatorGroup og = (OperatorGroup)this.loadGroup(group.getId(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
            groupId = og.getMember().getGroup().getId();
        } else {
            groupId = group.getId();
        }
        return "group_" + groupId.toString();
    }

    private String pathPart(GroupFilter groupFilter) {
        if (groupFilter == null) {
            return null;
        }
        return "group_filter_" + groupFilter.getId();
    }

    private String resolveName(CustomizedFile file) {
        String extension;
        String filename;
        CustomizedFile.Type type = file.getType();
        String name = file.getName();
        Group group = file.getGroup();
        GroupFilter groupFilter = file.getGroupFilter();
        if (type != CustomizedFile.Type.STYLE || group == null && groupFilter == null) {
            return name;
        }
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            filename = name;
            extension = "";
        } else {
            filename = name.substring(0, pos);
            extension = name.substring(pos + 1);
        }
        String pathPart = group != null ? this.pathPart(group, false) : this.pathPart(groupFilter);
        name = filename + "_" + pathPart + (StringUtils.isEmpty((String)extension) ? "" : "." + extension);
        return name;
    }

    public static enum CustomizationLevel {
        GROUP,
        GROUP_FILTER,
        GLOBAL,
        NONE;

    }

    public class CustomizationData {
        private CustomizationLevel level;
        private Long id;

        public CustomizationData(CustomizationLevel level) {
            this.level = level;
        }

        public CustomizationData(CustomizationLevel level, Long id) {
            this(level);
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public CustomizationLevel getLevel() {
            return this.level;
        }
    }
}

