/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.utils.query.IteratorList;
import org.hibernate.Hibernate;

public class DataIteratorHelper {
    private static final ThreadLocal<Map<Iterator<?>, Boolean>> OPEN_ITERATORS = new ThreadLocal();

    public static void close(Iterator<?> iterator) {
        DataIteratorHelper.close(iterator, true);
    }

    public static void close(IteratorList<?> iteratorList) {
        DataIteratorHelper.close(iteratorList.getIterator(), true);
    }

    public static void close(List<?> list) {
        Iterator<Object> iterator = list instanceof IteratorList ? ((IteratorList)list).getIterator() : list.iterator();
        DataIteratorHelper.close(iterator);
    }

    public static void closeOpenIterators() {
        Map<Iterator<?>, Boolean> iterators = OPEN_ITERATORS.get();
        if (iterators == null) {
            return;
        }
        for (Iterator<?> iterator : iterators.keySet()) {
            DataIteratorHelper.close(iterator, false);
        }
        iterators.clear();
        OPEN_ITERATORS.remove();
    }

    public static boolean hasOpenIteratorsRequiringOpenConnection() {
        Map<Iterator<?>, Boolean> iterators = OPEN_ITERATORS.get();
        if (iterators != null) {
            for (Boolean requiresOpenConnection : iterators.values()) {
                if (!Boolean.TRUE.equals(requiresOpenConnection)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerOpen(Iterator<?> iterator, boolean requiresOpenConnection) {
        if (iterator == null) {
            return;
        }
        Map<Iterator<?>, Boolean> iterators = OPEN_ITERATORS.get();
        if (iterators == null) {
            iterators = new HashMap();
            OPEN_ITERATORS.set(iterators);
        }
        iterators.put(iterator, requiresOpenConnection);
    }

    private static void close(Iterator<?> iterator, boolean remove) {
        Map<Iterator<?>, Boolean> iterators;
        if (iterator instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)iterator);
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        } else {
            try {
                Hibernate.close(iterator);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (remove && (iterators = OPEN_ITERATORS.get()) != null) {
            iterators.remove(iterator);
        }
    }
}

