/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.reports.ThroughTimeRange;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.Quarter;
import nl.strohalm.cyclos.utils.TimePeriod;
import org.apache.commons.lang.time.DateUtils;

public class DateHelper {
    public static int daysBetween(Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        date1 = DateHelper.truncate(date1);
        date2 = DateHelper.truncate(date2);
        return (int)((date2.getTimeInMillis() - date1.getTimeInMillis()) / 86400000L);
    }

    public static Calendar decimalDaysAdd(Calendar date1, BigDecimal augend) {
        if (date1 == null || augend == null) {
            return null;
        }
        BigDecimal date1InMillis = new BigDecimal(date1.getTimeInMillis());
        BigDecimal augendInMillis = augend.multiply(new BigDecimal(86400000L));
        BigDecimal resultAsBig = date1InMillis.add(augendInMillis);
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(resultAsBig.longValue());
        return result;
    }

    public static BigDecimal decimalDaysBetween(Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal difference = new BigDecimal(date2.getTimeInMillis() - date1.getTimeInMillis());
        MathContext mathContext = new MathContext(10);
        BigDecimal result = difference.divide(new BigDecimal(86400000L), mathContext);
        return result;
    }

    public static Calendar equalizeTime(Calendar toEqualize, Calendar source) {
        if (source == null) {
            return null;
        }
        int hourOfDay = source.get(11);
        int minute = source.get(12);
        int second = source.get(13);
        int milliSecond = source.get(14);
        Calendar result = (Calendar)toEqualize.clone();
        result.set(11, hourOfDay);
        result.set(12, minute);
        result.set(13, second);
        result.set(14, milliSecond);
        return result;
    }

    public static boolean equals(Calendar cal1, Calendar cal2, int level) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        Calendar temp1 = DateUtils.round((Calendar)((Calendar)cal1.clone()), (int)level);
        Calendar temp2 = DateUtils.round((Calendar)((Calendar)cal2.clone()), (int)level);
        return temp1.equals(temp2);
    }

    public static Calendar getDayEnd(Calendar date) {
        return TimePeriod.ONE_DAY.currentPeriod(date).getEnd();
    }

    public static Calendar getEarliest(Calendar ... dates) {
        Calendar oldest = null;
        for (Calendar date : dates) {
            if (oldest != null && (date == null || !oldest.after(date))) continue;
            oldest = date;
        }
        return oldest;
    }

    public static Map<String, Object> getLastCompletedMonthAndYear() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2);
        int year = now.get(1);
        if (month == 0) {
            month = 12;
            --year;
        } else {
            --month;
        }
        HashMap<String, Object> completedMonthAndYear = new HashMap<String, Object>();
        completedMonthAndYear.put("month", month);
        completedMonthAndYear.put("year", year);
        return completedMonthAndYear;
    }

    public static Map<String, Object> getLastCompletedQuarterAndYear() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2);
        int year = now.get(1);
        Quarter quarter = null;
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                quarter = Quarter.FOURTH;
                --year;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                quarter = Quarter.FIRST;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarter = Quarter.SECOND;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarter = Quarter.THIRD;
            }
        }
        HashMap<String, Object> completedQuarterAndYear = new HashMap<String, Object>();
        completedQuarterAndYear.put("quarter", quarter);
        completedQuarterAndYear.put("year", year);
        return completedQuarterAndYear;
    }

    public static Period[] getPeriodsThroughTheTime(Period period, ThroughTimeRange throughTimeRange) {
        Calendar calendarIni = period.getBegin();
        Calendar calendarFini = period.getEnd();
        ArrayList<Period> result = new ArrayList<Period>();
        int monthIni = calendarIni.get(2);
        int monthFini = calendarFini.get(2);
        int yearIni = calendarIni.get(1);
        int yearFini = calendarFini.get(1);
        for (int year = calendarIni.get(1); year <= calendarFini.get(1); ++year) {
            Period periodAux = null;
            int monthIniAux = 0;
            int monthFiniAux = 11;
            monthIniAux = year == yearIni ? monthIni : 0;
            monthFiniAux = year == yearFini ? monthFini : 11;
            int increment = 1;
            if (throughTimeRange == ThroughTimeRange.MONTH || throughTimeRange == ThroughTimeRange.QUARTER) {
                if (throughTimeRange == ThroughTimeRange.QUARTER) {
                    increment = 3;
                }
                for (int month = monthIniAux; month <= monthFiniAux; month += increment) {
                    GregorianCalendar calendarIniAux = new GregorianCalendar(year, month, 1, 0, 0, 0);
                    GregorianCalendar calendarFiniHlp = new GregorianCalendar(year, month + increment - 1, 1);
                    GregorianCalendar calendarFiniAux = new GregorianCalendar(year, month + increment - 1, ((Calendar)calendarFiniHlp).getActualMaximum(5), 23, 59, 59);
                    periodAux = new Period(calendarIniAux, calendarFiniAux);
                    result.add(periodAux);
                }
                continue;
            }
            if (throughTimeRange != ThroughTimeRange.YEAR) continue;
            GregorianCalendar calendarIniAux = new GregorianCalendar(year, 0, 1, 0, 0, 0);
            GregorianCalendar calendarFiniAux = new GregorianCalendar(year, 11, 31, 23, 59, 59);
            periodAux = new Period(calendarIniAux, calendarFiniAux);
            result.add(periodAux);
        }
        Period[] periodResult = new Period[result.size()];
        return result.toArray(periodResult);
    }

    public static Period getYearPeriod(int year) {
        Calendar begin = Calendar.getInstance();
        begin.set(1, year);
        begin = DateHelper.truncate(begin);
        Calendar end = Calendar.getInstance();
        end.set(1, year + 1);
        Period yearPeriod = new Period();
        yearPeriod.setBegin(begin);
        yearPeriod.setEnd(end);
        return yearPeriod;
    }

    public static boolean sameDay(Calendar first, Calendar second) {
        Calendar equalizedFirst = DateHelper.equalizeTime(first, second);
        return equalizedFirst.equals(second);
    }

    public static double secondsSince(long since) {
        return (double)(System.currentTimeMillis() - since) / 1000.0;
    }

    public static Calendar truncate(Calendar date) {
        if (date == null) {
            return null;
        }
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    public static Calendar truncateNextDay(Calendar date) {
        if (date == null) {
            return null;
        }
        date = (Calendar)date.clone();
        date.add(5, 1);
        return DateHelper.truncate(date);
    }

    public static Calendar truncatePreviosDay(Calendar date) {
        if (date == null) {
            return null;
        }
        date = (Calendar)date.clone();
        date.add(5, -1);
        return DateHelper.truncate(date);
    }
}

