/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import nl.strohalm.cyclos.utils.DataObject;

public class Dimensions
extends DataObject {
    private static final long serialVersionUID = 4164814243430488870L;
    private int width;
    private int height;

    public Dimensions() {
    }

    public Dimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isGreaterThan(Dimensions other) {
        return this.width > other.width || this.height > other.height;
    }

    public Dimensions resizeKeepingRatio(Dimensions maximum) {
        if (this.isGreaterThan(maximum)) {
            int newHeight = maximum.height;
            int newWidth = maximum.width;
            if ((float)this.height / (float)this.width > (float)newHeight / (float)newWidth) {
                newWidth = Math.round((float)newHeight / ((float)this.height / (float)this.width));
            } else if ((float)this.width / (float)this.height > (float)newWidth / (float)newHeight) {
                newHeight = Math.round((float)newWidth / ((float)this.width / (float)this.height));
            }
            if (newWidth == 0) {
                newWidth = 1;
            }
            if (newHeight == 0) {
                newHeight = 1;
            }
            return new Dimensions(newWidth, newHeight);
        }
        return (Dimensions)this.clone();
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return this.width + "x" + this.height;
    }
}

