/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.EntityVO;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.proxy.HibernateProxy;

public class EntityHelper {
    private static Long[] EMPTY_ARRAY = new Long[0];
    private static Map<Class<? extends Entity>, SortedMap<String, PropertyDescriptor>> cachedPropertiesByClass = new HashMap<Class<? extends Entity>, SortedMap<String, PropertyDescriptor>>();
    private static Map<Class<? extends Entity>, Class<? extends Entity>> cachedEntityTypes = new HashMap<Class<? extends Entity>, Class<? extends Entity>>();

    public static Class<? extends Entity> getRealClass(Entity entity) {
        Class<?> type = entity.getClass();
        if (entity instanceof EntityReference || entity instanceof HibernateProxy) {
            return type.getSuperclass();
        }
        return type;
    }

    public static Class<? extends Entity> getRealRootClass(Entity entity) {
        Class<? extends Entity> type = EntityHelper.getRealClass(entity);
        while (!type.getSuperclass().equals(Entity.class)) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static boolean isValidId(Long id) {
        return id != null && id > 0L;
    }

    public static boolean isValidId(String value) {
        try {
            long id = Long.parseLong(value);
            return EntityHelper.isValidId(id);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Set<Long> parseIds(String string) {
        String[] parts;
        HashSet<Long> ids = new HashSet<Long>();
        for (String part : parts = StringUtils.trimToEmpty((String)string).split(",")) {
            long id;
            if ((part = part.trim()).isEmpty()) continue;
            try {
                id = Long.parseLong(part);
                if (id <= 0L) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid id value:" + part);
            }
            ids.add(id);
        }
        return ids;
    }

    public static Map<String, PropertyDescriptor> propertyDescriptorsFor(Entity entity) {
        Class<? extends Entity> clazz = EntityHelper.getRealClass(entity);
        SortedMap<String, PropertyDescriptor> properties = cachedPropertiesByClass.get(clazz);
        if (properties == null) {
            PropertyDescriptor[] propertyDescriptors;
            properties = new TreeMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(clazz)) {
                Method readMethod;
                String name = descriptor.getName();
                boolean ok = name.equals("id");
                if (!ok && (readMethod = descriptor.getReadMethod()) != null) {
                    Class<?> declaringClass = readMethod.getDeclaringClass();
                    boolean bl = ok = !declaringClass.equals(Entity.class) && !declaringClass.equals(CustomFieldsContainer.class);
                }
                if (!ok) continue;
                properties.put(name, descriptor);
            }
            properties = Collections.unmodifiableSortedMap(properties);
            cachedPropertiesByClass.put(clazz, properties);
        }
        return properties;
    }

    public static Collection<String> propertyNamesFor(Entity entity) {
        return EntityHelper.propertyDescriptorsFor(entity).keySet();
    }

    public static <E extends Entity> E reference(Class<E> entityType, Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Class<? extends Entity> proxyClass = EntityHelper.resolveEntityClass(entityType);
        Entity proxy = ClassHelper.instantiate(proxyClass);
        ((ProxyObject)proxy).setHandler((MethodHandler)new InstanceMethodHandler(entityType, id));
        proxy.setId(id);
        return (E)proxy;
    }

    public static <E extends Entity> E[] references(Class<E> entityType, List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return (Entity[])Array.newInstance(entityType, 0);
        }
        Entity[] entities = (Entity[])Array.newInstance(entityType, ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            Long id = ids.get(i);
            entities[i] = EntityHelper.reference(entityType, id);
        }
        return entities;
    }

    public static Set<EntityVO> toEntityVO(Collection<? extends Entity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptySet();
        }
        TreeSet<EntityVO> orderedSet = new TreeSet<EntityVO>();
        for (Entity entity : entities) {
            orderedSet.add(entity.readOnlyView());
        }
        return orderedSet;
    }

    public static Long[] toIds(Collection<? extends Entity> entities) {
        if (entities == null || entities.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Long[] ids = new Long[entities.size()];
        int i = 0;
        for (Entity entity : entities) {
            ids[i++] = entity.getId();
        }
        return ids;
    }

    public static Long[] toIds(Entity ... entities) {
        if (entities == null || entities.length == 0) {
            return EMPTY_ARRAY;
        }
        return EntityHelper.toIds(Arrays.asList(entities));
    }

    public static Long[] toIds(String ... idsAsString) {
        if (idsAsString == null || idsAsString.length == 0) {
            return EMPTY_ARRAY;
        }
        Long[] ids = new Long[idsAsString.length];
        int i = 0;
        for (String idAsString : idsAsString) {
            ids[i++] = Long.valueOf(idAsString);
        }
        return ids;
    }

    public static Collection<Long> toIdsAsList(Collection<? extends Entity> entities) {
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>(entities.size());
        for (Entity entity : entities) {
            ids.add(entity.getId());
        }
        return ids;
    }

    public static String toIdsAsString(Collection<? extends Entity> entities) {
        return '[' + StringUtils.join((Object[])EntityHelper.toIds(entities), (char)',') + ']';
    }

    public static String toIdsAsString(Entity ... entities) {
        return '[' + StringUtils.join((Object[])EntityHelper.toIds(entities), (char)',') + ']';
    }

    private static synchronized Class<? extends Entity> resolveEntityClass(Class<? extends Entity> entityType) {
        Class proxyType = cachedEntityTypes.get(entityType);
        if (proxyType == null) {
            ProxyFactory factory = new ProxyFactory();
            factory.setInterfaces(new Class[]{EntityReference.class});
            factory.setSuperclass(entityType);
            proxyType = factory.createClass();
            cachedEntityTypes.put(entityType, proxyType);
        }
        return proxyType;
    }

    private static final class InstanceMethodHandler
    implements MethodHandler {
        private final Class<? extends Entity> entityType;
        private final Long id;

        private InstanceMethodHandler(Class<? extends Entity> entityType, Long id) {
            this.entityType = entityType;
            this.id = id;
        }

        public Object invoke(Object object, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (this.isExpectedMethod("toString", 0, thisMethod, args)) {
                return this.entityType.getSimpleName() + "#" + this.id;
            }
            return proceed.invoke(object, args);
        }

        private boolean isExpectedMethod(String expectedMethod, int expectedArgs, Method currentMethod, Object[] currentArgs) {
            return expectedMethod.equals(currentMethod.getName()) && expectedArgs == (currentArgs == null ? 0 : currentArgs.length);
        }
    }
}

