/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import nl.strohalm.cyclos.utils.DataObject;

public class EntityVO
extends DataObject
implements Comparable<EntityVO> {
    private static final long serialVersionUID = 1L;
    private long id;
    private String name;

    public EntityVO(long id, String name) {
        if (name == null) {
            throw new NullPointerException("Null name for EntityVO");
        }
        this.id = id;
        this.name = name;
    }

    @Override
    public int compareTo(EntityVO other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.id == other.id && this.name.equals(other.name)) {
            return 0;
        }
        int nameComparation = this.name.compareTo(other.name);
        return nameComparation == 0 ? Long.valueOf(this.id).compareTo(other.id) : nameComparation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityVO other = (EntityVO)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

