/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import org.apache.commons.collections.CollectionUtils;

public class EntityWithCustomFieldsWrapper
extends AbstractMap<String, Object> {
    private Map<String, String> cachedCustomValues;
    private final Collection<? extends CustomField> customFields;
    private final CustomFieldsContainer<?, ?> entity;
    private Set<Map.Entry<String, Object>> cachedEntrySet;
    private CustomFieldHelper customFieldHelper;

    public EntityWithCustomFieldsWrapper(CustomFieldsContainer<?, ?> entity, Collection<? extends CustomField> customFields, CustomFieldHelper customFieldHelper) {
        this.entity = entity;
        this.customFields = customFields;
        this.customFieldHelper = customFieldHelper;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.cachedEntrySet == null) {
            this.cachedEntrySet = this.createEntrySet();
        }
        return this.cachedEntrySet;
    }

    public CustomFieldValue getFieldValue(String internalName) {
        if (CollectionUtils.isEmpty(this.customFields)) {
            return null;
        }
        for (CustomFieldValue fieldValue : this.entity.getCustomValues()) {
            if (!fieldValue.getField().getInternalName().equals(internalName)) continue;
            return fieldValue;
        }
        return null;
    }

    private Set<Map.Entry<String, Object>> createEntrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (CustomField customField : this.customFields) {
            set.add(new EntryImpl(customField.getInternalName(), true));
        }
        Collection<String> basicProperties = EntityHelper.propertyNamesFor((Entity)((Object)this.entity));
        for (String property : basicProperties) {
            set.add(new EntryImpl(property, false));
        }
        return set;
    }

    private Map<String, String> resolveCustomValues() {
        if (this.cachedCustomValues == null) {
            this.cachedCustomValues = this.customFieldHelper.getFields(this.entity);
        }
        return this.cachedCustomValues;
    }

    public class EntryImpl
    implements Map.Entry<String, Object> {
        private final String key;
        private final boolean isCustom;

        EntryImpl(String key, boolean isCustom) {
            this.key = key;
            this.isCustom = isCustom;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            if (this.isCustom) {
                return EntityWithCustomFieldsWrapper.this.resolveCustomValues().get(this.key);
            }
            return PropertyHelper.get(EntityWithCustomFieldsWrapper.this.entity, this.key);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

