/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public final class EnumHelper {
    public static String capitalizeName(Enum<?> item) {
        String capitalized = StringUtils.replace((String)WordUtils.capitalizeFully((String)item.name(), (char[])new char[]{'_'}), (String)"_", (String)"");
        return Character.toLowerCase(capitalized.charAt(0)) + capitalized.substring(1);
    }

    public static <E extends Enum<?>> E findByValue(Class<E> enumType, String value) {
        for (Enum e : EnumHelper.values(enumType)) {
            if (!ObjectUtils.equals((Object)value, (Object)((StringValuedEnum)((Object)e)).getValue())) continue;
            return (E)e;
        }
        return null;
    }

    public static <E extends Enum<?>> E[] values(Class<E> enumType) {
        try {
            return (Enum[])EnumHelper.getValuesMethod(enumType).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't invoke values method on " + enumType + " (error: " + e.getMessage() + ")");
        }
    }

    public static <E extends Enum<?>> Map<Integer, E> valuesByIntValue(Class<E> enumType) {
        LinkedHashMap<Integer, Enum> map = new LinkedHashMap<Integer, Enum>();
        for (Enum e : EnumHelper.values(enumType)) {
            map.put(((IntValuedEnum)((Object)e)).getValue(), e);
        }
        return map;
    }

    public static <E extends Enum<?>> Map<String, E> valuesByName(Class<E> enumType) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : EnumHelper.values(enumType)) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static <E extends Enum<?>> Map<Integer, E> valuesByOrdinal(Class<E> enumType) {
        LinkedHashMap<Integer, Enum> map = new LinkedHashMap<Integer, Enum>();
        for (Enum e : EnumHelper.values(enumType)) {
            map.put(e.ordinal(), e);
        }
        return map;
    }

    public static <E extends Enum<?>> Map<String, E> valuesByStringValue(Class<E> enumType) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : EnumHelper.values(enumType)) {
            map.put(((StringValuedEnum)((Object)e)).getValue(), e);
        }
        return map;
    }

    private static <E extends Enum<?>> Method getValuesMethod(Class<E> enumType) {
        try {
            return enumType.getMethod("values", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("No values method on " + enumType);
        }
    }
}

