/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.sql.SQLException;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.PessimisticLockException;
import org.hibernate.exception.LockAcquisitionException;

public class ExceptionHelper {
    private static final int ER_LOCK_WAIT_TIMEOUT = 1205;
    private static final String ST_LOCK = "40001";

    public static boolean isLockingException(Throwable t) {
        return ExceptionHelper.isLockingException(t, true);
    }

    private static boolean isLockingException(Throwable t, boolean recurse) {
        if (t instanceof LockingException || t instanceof LockAcquisitionException || t instanceof PessimisticLockException) {
            return true;
        }
        if (t instanceof SQLException) {
            SQLException e = (SQLException)t;
            return e.getErrorCode() == 1205 || ST_LOCK.equals(e.getSQLState());
        }
        if (recurse) {
            for (Throwable thr : ExceptionUtils.getThrowables((Throwable)t)) {
                if (!ExceptionHelper.isLockingException(thr, false)) continue;
                return true;
            }
        }
        return false;
    }
}

