/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.Hibernate;

public class FormatObject {
    public static final String[] DEFAULT_EXCLUDES = new String[]{"password", "transactionPassword", "pin", "credential", "securityCode"};
    public static final String MASKED_VALUE = "***";
    private static final NumberFormat INTEGER_FORMAT = new DecimalFormat("#,##0", new DecimalFormatSymbols(Locale.US));
    private static final NumberFormat FLOAT_FORMAT = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(Locale.US));
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String formatArgument(Object argument) {
        boolean quote = argument instanceof String || argument instanceof Entity;
        String str = StringUtils.replace((String)FormatObject.formatObject(argument), (String)"\n", (String)"\\n");
        return quote ? '\"' + str + '\"' : str;
    }

    public static String formatObject(Object object) {
        return FormatObject.formatObject(object, "<null>");
    }

    public static String formatObject(Object object, String defaultValue) {
        return FormatObject.formatObject(object, defaultValue, "<empty>");
    }

    public static String formatObject(Object object, String defaultValue, String emptyValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            if (object instanceof Number) {
                if (object instanceof Float || object instanceof Double || object instanceof BigDecimal) {
                    return FLOAT_FORMAT.format(((Number)object).doubleValue());
                }
                return INTEGER_FORMAT.format(((Number)object).longValue());
            }
            if (object instanceof Calendar || object instanceof Date) {
                Date truncated;
                Date date = object instanceof Calendar ? ((Calendar)object).getTime() : (Date)object;
                if (date.equals(truncated = DateUtils.truncate((Date)date, (int)5))) {
                    return DATE_FORMAT.format(date);
                }
                return DATE_TIME_FORMAT.format(date);
            }
            if (object instanceof Collection || object instanceof Map || object.getClass().isArray()) {
                if (object instanceof Iterator) {
                    return "<iterator>";
                }
                if (Hibernate.isInitialized((Object)object)) {
                    Iterator iterator = object instanceof Map ? ((Map)object).entrySet().iterator() : IteratorUtils.getIterator((Object)object);
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    while (iterator.hasNext()) {
                        sb.append(FormatObject.formatArgument(iterator.next()));
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    return sb.toString();
                }
                return "<uninitialized collection>";
            }
            if (object instanceof String) {
                return "".equals("object") ? emptyValue : (String)object;
            }
            if (object instanceof Boolean) {
                return object.toString();
            }
            if (object instanceof Entity && object instanceof EntityReference || !Hibernate.isInitialized((Object)object)) {
                return ClassHelper.getClassName(EntityHelper.getRealClass((Entity)object)) + '#' + ((Entity)object).getId();
            }
            return object.toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String formatVO(Object vo) {
        return FormatObject.formatVO(vo, DEFAULT_EXCLUDES);
    }

    public static String formatVO(Object vo, String ... excludedProperties) {
        if (vo == null) {
            return "<null>";
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            ArrayList<String> exclude = new ArrayList<String>();
            exclude.add("class");
            if (excludedProperties != null && excludedProperties.length > 0) {
                exclude.addAll(Arrays.asList(excludedProperties));
            }
            StringBuilder sb = new StringBuilder();
            sb.append(ClassHelper.getClassName(vo.getClass())).append(" (");
            for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)vo)) {
                String value;
                String name = descriptor.getName();
                if (FormatObject.exclude(exclude, name)) continue;
                try {
                    value = FormatObject.formatArgument(PropertyHelper.get(vo, name));
                }
                catch (Exception e) {
                    value = "<error retrieving - is uninitialized?>";
                }
                sb.append(name).append('=').append(value).append(';');
            }
            sb.setLength(sb.length() - 1);
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return vo.toString();
        }
    }

    public static String maskIfNeeded(String name, Object value) {
        return FormatObject.shouldMask(name) ? MASKED_VALUE : FormatObject.formatObject(value);
    }

    public static boolean shouldMask(String name) {
        for (String exclude : DEFAULT_EXCLUDES) {
            if (!StringUtils.containsIgnoreCase((String)name, (String)exclude)) continue;
            return true;
        }
        return false;
    }

    private static boolean exclude(List<String> list, String string) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (String exclude : list) {
            if (!StringUtils.containsIgnoreCase((String)string, (String)exclude)) continue;
            return true;
        }
        return false;
    }
}

