/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import nl.strohalm.cyclos.entities.Application;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import org.apache.commons.lang.RandomStringUtils;

public class HashHandler {
    public static final String SHA_256 = "SHA-256";
    public static final String MD5 = "MD5";
    private ApplicationServiceLocal applicationService;

    public static String sha2(String string) {
        return HashHandler.digest(SHA_256, null, string);
    }

    private static String digest(String algorithm, String salt, String string) {
        if (string == null) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        md.reset();
        try {
            if (salt != null) {
                md.update(salt.getBytes("UTF-8"));
            }
            return HashHandler.toHex(md.digest(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String toHex(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] chars = new char[bytes.length * 2];
        int j = 0;
        byte[] arr$ = bytes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte element;
            byte k = element = arr$[i$];
            chars[j++] = hexDigits[k >>> 4 & 0xF];
            chars[j++] = hexDigits[k & 0xF];
        }
        return new String(chars);
    }

    public String hash(String salt, String string) {
        switch (this.getPasswordHash()) {
            case SHA2_SALT: {
                return HashHandler.digest(SHA_256, salt, string);
            }
            case SHA2: {
                return HashHandler.digest(SHA_256, null, string);
            }
            case SHA2_MD5: {
                return HashHandler.digest(SHA_256, null, HashHandler.digest(MD5, null, string));
            }
        }
        return null;
    }

    public String newSalt() {
        if (this.getPasswordHash() != Application.PasswordHash.SHA2_SALT) {
            return null;
        }
        return RandomStringUtils.randomAlphanumeric((int)32);
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    private Application.PasswordHash getPasswordHash() {
        return this.applicationService == null ? Application.PasswordHash.SHA2_SALT : this.applicationService.getPasswordHash();
    }
}

