/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingFactory;
import com.mullassery.imaging.util.Util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.utils.Dimensions;

public final class ImageHelper {
    private static final byte[] GIF_SIGNATURE = new byte[]{71, 73, 70};
    private static final byte[] JPEG_SIGNATURE = new byte[]{-1, -40, -1};
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static Imaging imaging;

    public static File generateThumbnail(BufferedImage image, String contentType, int maxWidth, int maxHeight) throws IOException {
        return ImageHelper.resizeGivenMaxDimensions(image, contentType, new Dimensions(maxWidth, maxHeight));
    }

    public static BufferedImage load(InputStream in) {
        return ImageHelper.imaging().read(in);
    }

    public static File resizeGivenMaxDimensions(BufferedImage image, String contentType, Dimensions maxDimensions) throws IOException, FileNotFoundException {
        Dimensions originalDimensions = new Dimensions(image.getWidth(), image.getHeight());
        if (ImageType.getByContentType(contentType) == ImageType.GIF) {
            contentType = "image/png";
        }
        Dimensions newDimensions = originalDimensions.resizeKeepingRatio(maxDimensions);
        BufferedImage thumbnail = ImageHelper.imaging().resize(image, newDimensions.getWidth(), newDimensions.getHeight());
        File thumbFile = File.createTempFile("cyclos", "image");
        Util.saveImage((Imaging)imaging, (BufferedImage)thumbnail, (String)ImageType.getByContentType(contentType).name(), (File)thumbFile);
        return thumbFile;
    }

    private static synchronized Imaging imaging() {
        if (imaging == null) {
            imaging = ImagingFactory.createImagingInstance();
        }
        return imaging;
    }

    static /* synthetic */ byte[] access$000() {
        return GIF_SIGNATURE;
    }

    static /* synthetic */ byte[] access$100() {
        return JPEG_SIGNATURE;
    }

    static /* synthetic */ byte[] access$200() {
        return PNG_SIGNATURE;
    }

    public static class UnknownImageTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 8673642585560912420L;
    }

    public static enum ImageType {
        GIF(ImageHelper.access$000(), "image/gif"),
        ICO(null, "image/x-ico", "image/x-icon", "image/ico"),
        JPEG(ImageHelper.access$100(), "image/jpeg", "image/pjpeg"),
        PNG(ImageHelper.access$200(), "image/png", "image/x-png");

        private final byte[] signature;
        private final String[] contentTypes;

        public static ImageType getByContent(byte[] firstBytes) {
            for (ImageType type : ImageType.values()) {
                byte[] signature = type.getSignature();
                if (signature == null || firstBytes.length < signature.length) continue;
                boolean starts = true;
                for (int i = 0; i < signature.length; ++i) {
                    if (signature[i] == firstBytes[i]) continue;
                    starts = false;
                    break;
                }
                if (!starts) continue;
                return type;
            }
            throw new UnknownImageTypeException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImageType getByContent(File file) throws IOException {
            FileInputStream in = new FileInputStream(file);
            try {
                byte[] buffer = new byte[10];
                in.read(buffer);
                ImageType imageType = ImageType.getByContent(buffer);
                return imageType;
            }
            finally {
                in.close();
            }
        }

        public static ImageType getByContentType(String contentType) {
            for (ImageType type : ImageType.values()) {
                List<String> types = Arrays.asList(type.contentTypes);
                if (!types.contains(contentType)) continue;
                return type;
            }
            throw new UnknownImageTypeException();
        }

        public static ImageType getByFileName(String fileName) {
            int sep = fileName.lastIndexOf(46);
            String extension = sep <= 0 ? "" : fileName.substring(sep + 1);
            if ((extension = extension.toLowerCase()).equals("jpg") || extension.equals("jpeg")) {
                return JPEG;
            }
            if (extension.equals("gif")) {
                return GIF;
            }
            if (extension.equals("png")) {
                return PNG;
            }
            if (extension.equals("ico")) {
                return ICO;
            }
            if (extension.equals("png")) {
                return PNG;
            }
            throw new UnknownImageTypeException();
        }

        private ImageType(byte[] signature, String ... contentTypes) {
            this.signature = signature;
            this.contentTypes = contentTypes;
        }

        public String getContentType() {
            return this.contentTypes[0];
        }

        public String[] getContentTypes() {
            return this.contentTypes;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public boolean isResizeSupported() {
            return this != ICO;
        }
    }
}

