/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class InternetAddressHelper {
    private static final Pattern HOSTNAME_PART = Pattern.compile("[a-z|A-Z|0-9|-]{1,63}");

    public static String[] getRangeBoundaries(String address) {
        int int2;
        if (!InternetAddressHelper.isIpRange(address)) {
            throw new IllegalArgumentException("Was expecting an IP range, but received \"" + address + "\"");
        }
        String[] parts = StringUtils.split((String)address, (char)'.');
        Object[] address1 = new String[4];
        Object[] address2 = new String[4];
        for (int i = 0; i < 3; ++i) {
            address1[i] = parts[i];
            address2[i] = parts[i];
        }
        String range = parts[3];
        String[] subParts = StringUtils.split((String)range, (char)'-');
        address1[3] = subParts[0];
        address2[3] = subParts[1];
        int int1 = Integer.parseInt(subParts[0]);
        if (int1 <= (int2 = Integer.parseInt(subParts[1]))) {
            return new String[]{StringUtils.join((Object[])address1, (char)'.'), StringUtils.join((Object[])address2, (char)'.')};
        }
        return new String[]{StringUtils.join((Object[])address2, (char)'.'), StringUtils.join((Object[])address1, (char)'.')};
    }

    public static boolean isHostname(String address) {
        if (StringUtils.isEmpty((String)address)) {
            return false;
        }
        if (address.length() > 255) {
            return false;
        }
        String[] parts = StringUtils.split((String)address, (char)'.');
        boolean allNumeric = true;
        for (String part : parts) {
            if (!HOSTNAME_PART.matcher(part).matches()) {
                return false;
            }
            if (StringUtils.isNumeric((String)part)) continue;
            allNumeric = false;
        }
        return !allNumeric;
    }

    public static boolean isIpRange(String address) {
        if (StringUtils.isEmpty((String)address)) {
            return false;
        }
        if (StringUtils.containsOnly((String)address, (String)"0123456789.-")) {
            String[] parts = StringUtils.split((String)address, (char)'.');
            if (parts.length != 4) {
                return false;
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (i == 3) {
                    String[] subParts = StringUtils.split((String)part, (char)'-');
                    if (subParts.length != 2) {
                        return false;
                    }
                    String begin = subParts[0];
                    String end = subParts[1];
                    return InternetAddressHelper.isValidIpPart(begin) && InternetAddressHelper.isValidIpPart(end);
                }
                if (InternetAddressHelper.isValidIpPart(part)) continue;
                return false;
            }
        }
        return false;
    }

    public static boolean isSimpleIp(String address) {
        if (StringUtils.isEmpty((String)address)) {
            return false;
        }
        if (StringUtils.containsOnly((String)address, (String)"0123456789.")) {
            String[] parts = StringUtils.split((String)address, (char)'.');
            if (parts.length != 4) {
                return false;
            }
            for (String part : parts) {
                if (InternetAddressHelper.isValidIpPart(part)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String padAddress(String address) {
        if (!InternetAddressHelper.isSimpleIp(address)) {
            throw new IllegalArgumentException("Was expecting an IP address, but received \"" + address + "\"");
        }
        Object[] parts = StringUtils.split((String)address, (char)'.');
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.leftPad((String)parts[i], (int)3, (char)'0');
        }
        return StringUtils.join((Object[])parts, (char)'.');
    }

    public static AddressType resolveAddressType(String address) {
        if (InternetAddressHelper.isSimpleIp(address)) {
            return AddressType.SIMPLE_IP;
        }
        if (InternetAddressHelper.isIpRange(address)) {
            return AddressType.IP_RANGE;
        }
        if (InternetAddressHelper.isHostname(address)) {
            return AddressType.HOSTNAME;
        }
        return null;
    }

    private static boolean isValidIpPart(String part) {
        try {
            int value = Integer.parseInt(part);
            return value >= 0 && value <= 255;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum AddressType {
        HOSTNAME,
        SIMPLE_IP,
        IP_RANGE;

    }
}

