/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.lang.ArrayUtils;

public class JDBCWrapper {
    private final Connection connection;

    public static void closeQuietly(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet rs) {
        Statement st = null;
        try {
            st = rs.getStatement();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDBCWrapper.closeQuietly(st);
    }

    public static void closeQuietly(Statement st) {
        try {
            st.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setParameters(PreparedStatement ps, Object ... parameters) throws SQLException {
        if (ps == null || ArrayUtils.isEmpty((Object[])parameters)) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Object object = parameters[i];
            int index = i + 1;
            if (object instanceof Number) {
                ps.setBigDecimal(index, CoercionHelper.coerce(BigDecimal.class, object));
                continue;
            }
            if (object instanceof Calendar || object instanceof Date) {
                Calendar cal = CoercionHelper.coerce(Calendar.class, object);
                ps.setTimestamp(index, new Timestamp(cal.getTimeInMillis()));
                continue;
            }
            if (object instanceof Boolean) {
                ps.setBoolean(index, (Boolean)object);
                continue;
            }
            ps.setString(index, CoercionHelper.coerce(String.class, object));
        }
    }

    public JDBCWrapper(Connection connection) {
        this.connection = connection;
    }

    public void close() {
        JDBCWrapper.closeQuietly(this.connection);
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String statement, Object ... parameters) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(statement);
        try {
            JDBCWrapper.setParameters(ps, parameters);
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            JDBCWrapper.closeQuietly(ps);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isHSQLDB() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductName().toLowerCase().startsWith("hsql");
    }

    public ResultSet query(String sql, Object ... parameters) throws SQLException {
        return this.doQuery(sql, 1007, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long readScalarAsLong(String sql, Object ... parameters) throws SQLException {
        ResultSet rs;
        block4: {
            long data;
            block5: {
                Long l;
                PreparedStatement ps = this.connection.prepareStatement(sql);
                rs = null;
                try {
                    JDBCWrapper.setParameters(ps, parameters);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block4;
                    data = rs.getLong(1);
                    if (!rs.wasNull()) break block5;
                    l = null;
                }
                catch (Throwable throwable) {
                    JDBCWrapper.closeQuietly(rs);
                    throw throwable;
                }
                JDBCWrapper.closeQuietly(rs);
                return l;
            }
            Long l = data;
            JDBCWrapper.closeQuietly(rs);
            return l;
        }
        Long l = null;
        JDBCWrapper.closeQuietly(rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> readScalarAsLongList(String sql, Object ... parameters) throws SQLException {
        LinkedList<Long> linkedList;
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ResultSet rs = null;
        try {
            JDBCWrapper.setParameters(ps, parameters);
            rs = ps.executeQuery();
            LinkedList<Long> list = new LinkedList<Long>();
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            linkedList = list;
        }
        catch (Throwable throwable) {
            JDBCWrapper.closeQuietly(rs);
            throw throwable;
        }
        JDBCWrapper.closeQuietly(rs);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readScalarAsString(String sql, Object ... parameters) throws SQLException {
        ResultSet rs;
        block3: {
            String string;
            PreparedStatement ps = this.connection.prepareStatement(sql);
            rs = null;
            try {
                JDBCWrapper.setParameters(ps, parameters);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                JDBCWrapper.closeQuietly(rs);
                throw throwable;
            }
            JDBCWrapper.closeQuietly(rs);
            return string;
        }
        String string = null;
        JDBCWrapper.closeQuietly(rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readScalarAsStringList(String sql, Object ... parameters) throws SQLException {
        LinkedList<String> linkedList;
        PreparedStatement ps = this.connection.prepareStatement(sql);
        ResultSet rs = null;
        try {
            JDBCWrapper.setParameters(ps, parameters);
            rs = ps.executeQuery();
            LinkedList<String> list = new LinkedList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            linkedList = list;
        }
        catch (Throwable throwable) {
            JDBCWrapper.closeQuietly(rs);
            throw throwable;
        }
        JDBCWrapper.closeQuietly(rs);
        return linkedList;
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public ResultSet updatableQuery(String sql, Object ... parameters) throws SQLException {
        return this.doQuery(sql, 1008, parameters);
    }

    private ResultSet doQuery(String sql, int concurrency, Object ... parameters) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, 1004, concurrency);
        JDBCWrapper.setParameters(ps, parameters);
        return ps.executeQuery();
    }
}

