/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntry;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.GeneralReference;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.entities.members.TransactionFeedbackRequest;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.LinkGenerator;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinkGeneratorImpl
implements LinkGenerator {
    private static final Log LOG = LogFactory.getLog(LinkGeneratorImpl.class);
    private SettingsService settingsService;
    private MessageHelper messageHelper;
    private GroupService groupService;

    @Override
    public String generateForApplicationRoot(Element element) {
        return this.buildTagFor(this.getRootUrl(element));
    }

    @Override
    public String generateLinkFor(Element element, Entity entity) throws EntityNotFoundException {
        String relativePath = "";
        if (entity instanceof Ad) {
            relativePath = "viewAd?id=";
        } else if (entity instanceof Member) {
            relativePath = "profile?memberId=";
        } else if (entity instanceof Invoice) {
            relativePath = "invoiceDetails?invoiceId=";
        } else if (entity instanceof Transfer) {
            relativePath = "viewTransaction?transferId=";
        } else if (entity instanceof GeneralReference) {
            relativePath = "generalReferenceDetails?referenceId=";
        } else if (entity instanceof TransactionFeedback) {
            relativePath = "transactionFeedbackDetails?referenceId=";
        } else if (entity instanceof TransactionFeedbackRequest) {
            TransactionFeedbackRequest transactionFeedbackRequest = (TransactionFeedbackRequest)entity;
            String paramName = transactionFeedbackRequest.getPayment() instanceof ScheduledPayment ? "scheduledPaymentId" : "transferId";
            relativePath = "transactionFeedbackDetails?" + paramName + "=";
        } else if (entity instanceof Loan) {
            relativePath = "loanDetails?loanId=";
        } else if (entity instanceof ErrorLogEntry) {
            relativePath = "viewErrorLogEntry?entryId=";
        } else if (entity instanceof BrokerCommissionContract) {
            relativePath = "editBrokerCommissionContract?brokerCommissionContractId=";
        } else if (entity instanceof Certification) {
            relativePath = "editCertification?certificationId=";
        } else if (entity instanceof Guarantee) {
            relativePath = "guaranteeDetails?guaranteeId=";
        } else if (entity instanceof PaymentObligation) {
            relativePath = "editPaymentObligation?paymentObligationId=";
        } else {
            throw new EntityNotFoundException(entity.getClass());
        }
        String path = "do/" + element.getNature().name().toLowerCase() + "/" + relativePath + entity.getId();
        String baseUrl = this.getBaseUrl(element);
        String pathPart = "/do/redirectFromMessage?userId=" + element.getId() + "&path=" + StringHelper.encodeUrl("/" + path);
        return this.buildTagFor(this.resolveUrl(baseUrl, pathPart));
    }

    @Override
    public String generateLinkForMailChangeValidation(PendingEmailChange change) {
        return this.buildTagFor(this.getMailChangeValidationUrl(change));
    }

    @Override
    public String generateLinkForMailValidation(MemberGroup group, String key) {
        return this.buildTagFor(this.getMailValidationUrl(group, key));
    }

    @Override
    public String getMailChangeValidationUrl(PendingEmailChange change) {
        String baseUrl = this.getBaseUrl(change.getMember());
        String pathPart = "/do/redirectFromMessage?userId=" + change.getMember().getId() + "&path=/do/member/validateEmailChange?key=" + change.getValidationKey();
        return this.resolveUrl(baseUrl, pathPart);
    }

    @Override
    public String getMailValidationUrl(MemberGroup group, String key) {
        String baseUrl = this.getBaseUrl(group);
        String pathPart = "/do/validateRegistration?key=" + key;
        return this.resolveUrl(baseUrl, pathPart);
    }

    @Override
    public String getRootUrl(Element element) {
        return this.getBaseUrl(element) + "/";
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    private String buildTagFor(String url) {
        String label = this.messageHelper.message("message.link.label", new Object[0]);
        return this.buildTagFor(url, label);
    }

    private String buildTagFor(String url, String label) {
        return "<a class=\"default\" href=\"" + url + "\">" + label + "</a>";
    }

    private String getBaseUrl(Element element) {
        SystemGroup group = element instanceof Operator ? (SystemGroup)this.loadGroup(((Operator)element).getMember().getGroup().getId()) : (SystemGroup)this.loadGroup(element.getGroup().getId());
        return this.getBaseUrl(group);
    }

    private String getBaseUrl(SystemGroup group) {
        String url = (group = (SystemGroup)this.loadGroup(group.getId())).getRootUrl();
        if (StringUtils.isEmpty((String)url)) {
            Collection<GroupFilter> groupFilters = group.getGroupFilters();
            for (GroupFilter groupFilter : groupFilters) {
                if (!StringUtils.isNotEmpty((String)groupFilter.getRootUrl())) continue;
                url = groupFilter.getRootUrl();
                break;
            }
        }
        if (StringUtils.isEmpty((String)url)) {
            url = this.settingsService.getLocalSettings().getRootUrl();
        }
        if (StringUtils.isEmpty((String)url)) {
            LOG.error((Object)"No root url was found when generating a link");
            return "";
        }
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    private Group loadGroup(final Long id) {
        return LoggedUser.runAsSystem(new Callable<Group>(){

            @Override
            public Group call() throws Exception {
                return LinkGeneratorImpl.this.groupService.load(id, Group.Relationships.GROUP_FILTERS);
            }
        });
    }

    private String resolveUrl(String baseUrl, String pathPart) {
        if (baseUrl.contains("?")) {
            try {
                pathPart = URLEncoder.encode(pathPart, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return baseUrl + pathPart;
    }
}

