/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.records.MemberRecordTypeQuery;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.exceptions.AccessDeniedException;
import nl.strohalm.cyclos.exceptions.LoggedOutException;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.LoginException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.loangroups.LoanGroupService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.Navigation;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.query.PageHelper;
import org.apache.commons.lang.StringUtils;

public class LoginHelper {
    private ChannelService channelService;
    private ElementService elementService;
    private AccessService accessService;
    private GroupService groupService;
    private AccountService accountService;
    private PermissionService permissionService;
    private DocumentService documentService;
    private LoanGroupService loanGroupService;
    private ReferenceService referenceService;
    private MemberRecordTypeService memberRecordTypeService;
    private GuaranteeService guaranteeService;
    private SettingsService settingsService;
    private CommissionService commissionService;
    private ReceiptPrinterSettingsService receiptPrinterSettingsService;
    private boolean newSessionAfterLogin;

    public static User getLoggedUser(HttpServletRequest request) {
        return (User)request.getAttribute("loggedUser");
    }

    public User login(Class<? extends User> requiredUserClass, String principalTypeString, String memberUsername, String principal, String password, String channel, HttpServletRequest request, HttpServletResponse response) throws LoginException {
        Long id;
        String receiptPrinterId;
        User user;
        String remoteAddress = request.getRemoteAddr();
        PrincipalType principalType = this.channelService.resolvePrincipalType(channel, principalTypeString);
        String usernameToVerify = principal;
        if (principalType.getPrincipal() != Channel.Principal.USER) {
            try {
                Member member = this.elementService.loadByPrincipal(principalType, principal, Element.Relationships.USER, Element.Relationships.GROUP);
                usernameToVerify = member.getUsername();
            }
            catch (EntityNotFoundException e) {
                usernameToVerify = "";
            }
        }
        if (!requiredUserClass.isInstance(user = this.accessService.verifyLogin(memberUsername, usernameToVerify, remoteAddress))) {
            throw new AccessDeniedException();
        }
        Group group = user.getElement().getGroup();
        boolean isAdmin = group instanceof AdminGroup;
        boolean isMember = group instanceof MemberGroup;
        boolean isBroker = group instanceof BrokerGroup;
        boolean isOperator = group instanceof OperatorGroup;
        boolean isPosWeb = RequestHelper.isPosWeb(request);
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        if (isAdmin && !accessSettings.getAdministrationWhitelistValidator().isAllowed(request.getRemoteHost(), request.getRemoteAddr())) {
            throw new AccessDeniedException();
        }
        HttpSession session = this.newSessionAfterLogin ? this.createNewSessionForlogin(request) : request.getSession();
        this.accessService.login(user, password, channel, isPosWeb, remoteAddress, session.getId());
        TimePeriod timeout = isPosWeb ? accessSettings.getPoswebTimeout() : (isMember ? accessSettings.getMemberTimeout() : accessSettings.getAdminTimeout());
        int timeoutSeconds = (int)timeout.getValueIn(TimePeriod.Field.SECONDS);
        if (timeoutSeconds <= 0) {
            timeoutSeconds = -1;
        }
        session.setMaxInactiveInterval(timeoutSeconds);
        boolean hasAccounts = false;
        boolean singleAccount = false;
        boolean hasDocuments = false;
        boolean hasLoanGroups = false;
        boolean hasGeneralReferences = false;
        boolean hasTransactionFeedbacks = false;
        boolean hasPin = false;
        boolean hasExternalChannels = false;
        boolean hasCards = false;
        boolean hasPos = false;
        boolean hasCommissionContracts = false;
        if (isMember || isOperator) {
            MemberGroup memberGroup;
            Member member;
            if (isMember) {
                member = ((MemberUser)user).getMember();
                memberGroup = (MemberGroup)this.groupService.load(member.getMemberGroup().getId(), MemberGroup.Relationships.CHANNELS);
                hasPin = this.groupService.usesPin(memberGroup);
                for (Channel current : memberGroup.getChannels()) {
                    if ("web".equals(current.getInternalName())) continue;
                    hasExternalChannels = true;
                    break;
                }
                if (!member.getPosDevices().isEmpty()) {
                    hasPos = true;
                    if (member.getPosDevices().size() == 1) {
                        Collection<MemberPos> memberPos = member.getPosDevices();
                        for (MemberPos mpos : memberPos) {
                            session.setAttribute("uniqueMemberPosId ", (Object)mpos.getPos().getId());
                        }
                    }
                }
            } else {
                member = ((OperatorUser)user).getOperator().getMember();
            }
            member = (Member)this.elementService.load(member.getId(), Member.Relationships.BROKER);
            memberGroup = member.getMemberGroup();
            List<? extends Account> accounts = this.accountService.getAccounts(member, new Relationship[0]);
            hasAccounts = !accounts.isEmpty();
            boolean bl = singleAccount = accounts.size() == 1;
            if (isMember) {
                if (this.permissionService.hasPermission(MemberPermission.DOCUMENTS_VIEW)) {
                    hasDocuments = true;
                } else {
                    DocumentQuery documentQuery = new DocumentQuery();
                    documentQuery.setNatures(Collections.singleton(Document.Nature.MEMBER));
                    documentQuery.setMember(member);
                    documentQuery.setPageForCount();
                    hasDocuments = PageHelper.hasResults(this.documentService.search(documentQuery));
                }
                LoanGroupQuery lgq = new LoanGroupQuery();
                lgq.setPageForCount();
                lgq.setMember(member);
                hasLoanGroups = PageHelper.hasResults(this.loanGroupService.search(lgq));
                hasCommissionContracts = this.commissionService.hasBrokerCommissionContracts();
            }
            Collection<Reference.Nature> referenceNatures = this.referenceService.getNaturesByGroup(memberGroup);
            hasGeneralReferences = referenceNatures.contains(Reference.Nature.GENERAL);
            hasTransactionFeedbacks = referenceNatures.contains(Reference.Nature.TRANSACTION);
            try {
                Collection<GuaranteeType.Model> guaranteeModels = this.guaranteeService.getRelatedGuaranteeModels();
                session.setAttribute("loggedMemberHasGuarantees", (Object)(guaranteeModels.size() > 0 ? 1 : 0));
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean bl2 = hasCards = !member.getCards().isEmpty();
        }
        if (isAdmin || isBroker) {
            MemberRecordTypeQuery query = new MemberRecordTypeQuery();
            if (isAdmin) {
                query.setViewableByAdminGroup((AdminGroup)group);
            } else {
                query.setViewableByBrokerGroup((BrokerGroup)group);
            }
            query.setShowMenuItem(true);
            List<MemberRecordType> types = this.memberRecordTypeService.search(query);
            session.setAttribute("memberRecordTypesInMenu", types);
        }
        if (StringUtils.isNotEmpty((String)(receiptPrinterId = RequestHelper.getCookieValue((ServletRequest)request, "receiptPrinterId"))) && !this.receiptPrinterSettingsService.belongsToTheLoggedUser(id = IdConverter.instance().valueOf(receiptPrinterId))) {
            Cookie cookie = new Cookie("receiptPrinterId", "");
            cookie.setPath(request.getContextPath());
            response.addCookie(cookie);
        }
        String actionPrefix = "/" + (isAdmin ? "admin" : (isMember ? "member" : "operator"));
        request.setAttribute("loggedUser", (Object)user);
        request.setAttribute("loggedElement", (Object)user.getElement());
        session.setAttribute("loggedUserId", (Object)user.getId());
        session.setAttribute("isAdmin", (Object)isAdmin);
        session.setAttribute("isMember", (Object)isMember);
        session.setAttribute("isBroker", (Object)isBroker);
        session.setAttribute("isOperator", (Object)isOperator);
        session.setAttribute("isBuyer", (Object)this.guaranteeService.isBuyer());
        session.setAttribute("isSeller", (Object)this.guaranteeService.isSeller());
        session.setAttribute("isIssuer", (Object)this.guaranteeService.isIssuer());
        session.setAttribute("loggedMemberHasAccounts", (Object)hasAccounts);
        session.setAttribute("loggedMemberHasSingleAccount", (Object)singleAccount);
        session.setAttribute("loggedMemberHasDocuments", (Object)hasDocuments);
        session.setAttribute("loggedMemberHasLoanGroups", (Object)hasLoanGroups);
        session.setAttribute("loggedMemberHasGeneralReferences", (Object)hasGeneralReferences);
        session.setAttribute("loggedMemberHasTransactionFeedbacks", (Object)hasTransactionFeedbacks);
        session.setAttribute("hasPin", (Object)hasPin);
        session.setAttribute("hasCards", (Object)hasCards);
        session.setAttribute("hasPos", (Object)hasPos);
        session.setAttribute("hasCommissionContracts", (Object)hasCommissionContracts);
        session.setAttribute("hasExternalChannels", (Object)hasExternalChannels);
        session.setAttribute("actionPrefix", (Object)actionPrefix);
        session.setAttribute("pathPrefix", (Object)("/do" + actionPrefix));
        session.setAttribute("navigation", (Object)Navigation.get(session));
        return user;
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setCommissionService(CommissionService commissionService) {
        this.commissionService = commissionService;
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.newSessionAfterLogin = Boolean.parseBoolean(cyclosProperties.getProperty("cyclos.newSessionAfterLogin", "true"));
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setGuaranteeService(GuaranteeService guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setLoanGroupService(LoanGroupService loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setReceiptPrinterSettingsService(ReceiptPrinterSettingsService receiptPrinterSettingsService) {
        this.receiptPrinterSettingsService = receiptPrinterSettingsService;
    }

    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public User validateLoggedUser(HttpServletRequest request) {
        boolean valid;
        User serviceUser;
        HttpSession session = request.getSession();
        User user = LoginHelper.getLoggedUser(request);
        if (user == null) {
            throw new LoggedOutException();
        }
        try {
            serviceUser = this.accessService.getLoggedUser(session.getId());
        }
        catch (NotConnectedException e) {
            throw new LoggedOutException();
        }
        if (user != null && serviceUser == null) {
            session.removeAttribute("loggedUser");
            throw new LoggedOutException();
        }
        boolean bl = valid = user != null && user.equals(serviceUser);
        if (!valid) {
            session.invalidate();
            throw new AccessDeniedException();
        }
        return user;
    }

    private HttpSession createNewSessionForlogin(HttpServletRequest request) {
        HttpSession session = request.getSession();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            attrMap.put(attrName, session.getAttribute(attrName));
        }
        session.invalidate();
        session = request.getSession();
        for (Map.Entry entry : attrMap.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return session;
    }
}

