/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.PendingEmailChange;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.MailSettings;
import nl.strohalm.cyclos.entities.settings.MailTranslation;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.exceptions.MailSendingException;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.LinkGenerator;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.WorkerThreads;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailHandler
implements InitializingBean,
DisposableBean {
    private SettingsServiceLocal settingsService;
    private LinkGenerator linkGenerator;
    private MessageResolver messageResolver = new MessageResolver.NoOpMessageResolver();
    private SenderThreads senderThreads;
    private int maxThreads = 5;

    public void afterPropertiesSet() throws Exception {
        this.senderThreads = new SenderThreads("Cyclos mail sender", this.maxThreads);
    }

    public void destroy() throws Exception {
        if (this.senderThreads != null) {
            this.senderThreads.interrupt();
            this.senderThreads = null;
        }
    }

    public InternetAddress getInternetAddress(Element element) {
        if (element == null) {
            return null;
        }
        return this.getInternetAddress(element.getName(), element.getEmail());
    }

    public InternetAddress getInternetAddress(PendingMember pendingMember) {
        if (pendingMember == null) {
            return null;
        }
        return this.getInternetAddress(pendingMember.getName(), pendingMember.getEmail());
    }

    public InternetAddress getInternetAddress(String name, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (StringUtils.isEmpty((String)name)) {
            name = email;
        }
        try {
            return new InternetAddress(email, name, localSettings.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public InternetAddress getMailAddress(String mail) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        try {
            return new InternetAddress(mail, mail, localSettings.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public InternetAddress getReplyAddress(Element element) {
        Member member;
        if (element instanceof Operator) {
            element = ((Operator)element).getMember();
        }
        if (element instanceof Member && (member = (Member)element).isHideEmail()) {
            return null;
        }
        return this.getInternetAddress(element);
    }

    public InternetAddress getSystemAddress() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MailSettings mailSettings = this.settingsService.getMailSettings();
        try {
            return new InternetAddress(mailSettings.getFromMail(), localSettings.getApplicationName(), localSettings.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String processBody(Element owner, String body, Member member, MessageCategory category, boolean isHtml) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        String lineSep = isHtml ? "<br>" : "\n";
        StringBuilder sb = new StringBuilder();
        boolean appendExtraLine = false;
        if (member != null || category != null) {
            sb.append(this.processLabel("message.from", isHtml));
            if (member == null) {
                sb.append(localSettings.getApplicationUsername());
            } else {
                sb.append(member.getName()).append(" (").append(member.getUsername()).append(")");
            }
            sb.append(lineSep);
            appendExtraLine = true;
        }
        if (category != null) {
            sb.append(this.processLabel("message.category", isHtml));
            sb.append(category.getName());
            sb.append(lineSep);
            appendExtraLine = true;
        }
        if (appendExtraLine) {
            sb.append(lineSep);
        }
        sb.append(body);
        sb.append(lineSep);
        sb.append(lineSep);
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String suffix = isHtml ? messageSettings.getMessageMailSuffixHtml() : messageSettings.getMessageMailSuffixPlain();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("link", this.getRootUrl(owner, isHtml, true));
        variables.put("system_name", localSettings.getApplicationName());
        sb.append(MessageProcessingHelper.processVariables(suffix, variables));
        return sb.toString();
    }

    public String processSubject(Element owner, String subject) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String prefix = StringUtils.trimToEmpty((String)messageSettings.getMessageMailSubjectPrefix());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("link", this.getRootUrl(owner, false, true));
        variables.put("system_name", localSettings.getApplicationName());
        prefix = MessageProcessingHelper.processVariables(prefix, variables);
        return StringUtils.trimToEmpty((String)(prefix + " " + subject));
    }

    public void send(String subject, InternetAddress replyTo, InternetAddress to, String body, boolean isHTML) {
        this.doSend(subject, replyTo, to, body, isHTML, false);
    }

    public void sendActivation(boolean threaded, Member member, String password) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Map<String, Object> variableValues = member.getVariableValues(localSettings);
        variableValues.put("password", password);
        variableValues.put("system_name", localSettings.getApplicationName());
        variableValues.put("link", this.getRootUrl(member, true, false));
        variableValues.put("url", this.getRootUrl(member, true, true));
        MailTranslation mailTranslation = this.settingsService.getMailTranslation();
        String subject = mailTranslation.getActivationSubject();
        String body = password == null ? mailTranslation.getActivationMessageWithoutPassword() : mailTranslation.getActivationMessageWithPassword();
        this.sendInternal(threaded, this.getInternetAddress(member), variableValues, subject, body);
    }

    public void sendAfterTransactionCommit(final String subject, final InternetAddress replyTo, final InternetAddress to, final String body, final boolean isHTML) {
        if (this.senderThreads == null) {
            return;
        }
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                MailParameters params = new MailParameters();
                params.subject = subject;
                params.replyTo = replyTo;
                params.to = to;
                params.body = body;
                params.isHTML = isHTML;
                MailHandler.this.senderThreads.enqueue(params);
            }
        });
    }

    public void sendEmailChange(PendingEmailChange pendingEmailChange) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Map<String, Object> variableValues = pendingEmailChange.getVariableValues(localSettings);
        variableValues.put("system_name", localSettings.getApplicationName());
        variableValues.put("link", this.linkGenerator.generateLinkForMailChangeValidation(pendingEmailChange));
        variableValues.put("url", this.linkGenerator.getMailChangeValidationUrl(pendingEmailChange));
        MailTranslation mailTranslation = this.settingsService.getMailTranslation();
        String subject = mailTranslation.getMailChangeValidationSubject();
        String body = mailTranslation.getMailChangeValidationMessage();
        Member member = pendingEmailChange.getMember();
        InternetAddress internetAddress = this.getInternetAddress(member.getName(), pendingEmailChange.getNewEmail());
        this.sendInternal(false, internetAddress, variableValues, subject, body);
    }

    public void sendEmailValidation(PendingMember pendingMember) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Map<String, Object> variableValues = pendingMember.getVariableValues(localSettings);
        variableValues.put("system_name", localSettings.getApplicationName());
        String key = pendingMember.getValidationKey();
        variableValues.put("link", this.linkGenerator.generateLinkForMailValidation(pendingMember.getMemberGroup(), key));
        variableValues.put("url", this.linkGenerator.getMailValidationUrl(pendingMember.getMemberGroup(), key));
        MailTranslation mailTranslation = this.settingsService.getMailTranslation();
        String subject = mailTranslation.getMailValidationSubject();
        String body = mailTranslation.getMailValidationMessage();
        this.sendInternal(false, this.getInternetAddress(pendingMember), variableValues, subject, body);
    }

    public void sendInvitation(Element fromElement, String toMail) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Map<String, Object> variableValues = fromElement.getVariableValues(localSettings);
        variableValues.put("system_name", localSettings.getApplicationName());
        variableValues.put("link", this.getRootUrl(fromElement, true, true));
        MailTranslation mailTranslation = this.settingsService.getMailTranslation();
        String subject = mailTranslation.getInvitationSubject();
        String body = mailTranslation.getInvitationMessage();
        this.sendInternal(false, this.getMailAddress(toMail), variableValues, subject, body);
    }

    public void sendResetPassword(Member member, String password) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Map<String, Object> variableValues = member.getVariableValues(localSettings);
        variableValues.put("password", password);
        variableValues.put("system_name", localSettings.getApplicationName());
        variableValues.put("link", this.getRootUrl(member, true, true));
        MailTranslation mailTranslation = this.settingsService.getMailTranslation();
        String subject = mailTranslation.getResetPasswordSubject();
        String body = mailTranslation.getResetPasswordMessage();
        this.sendInternal(false, this.getInternetAddress(member), variableValues, subject, body);
    }

    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    private void doSend(String subject, InternetAddress replyTo, InternetAddress to, String body, boolean isHTML, boolean throwException) {
        if (to == null || StringUtils.isEmpty((String)to.getAddress())) {
            return;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MailSettings mailSettings = this.settingsService.getMailSettings();
        JavaMailSender mailSender = mailSettings.getMailSender();
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, localSettings.getCharset());
        try {
            helper.setFrom(this.getSystemAddress());
            if (replyTo != null) {
                helper.setReplyTo(replyTo);
            }
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(body, isHTML);
            mailSender.send(message);
        }
        catch (MessagingException e) {
            if (throwException) {
                throw new MailSendingException(subject, e);
            }
            CurrentTransactionData.setMailError(new MailSendingException(subject, e));
        }
        catch (MailException e) {
            if (throwException) {
                throw new MailSendingException(subject, e);
            }
            CurrentTransactionData.setMailError(new MailSendingException(subject, e));
        }
    }

    private String getRootUrl(Element element, boolean isHtml, boolean useUrlAsLink) {
        if (this.linkGenerator == null) {
            return "";
        }
        String rootUrl = this.linkGenerator.getRootUrl(element);
        if (isHtml) {
            if (useUrlAsLink) {
                return "<a href='" + rootUrl + "'>" + rootUrl + "</a>";
            }
            return this.linkGenerator.generateForApplicationRoot(element);
        }
        return rootUrl;
    }

    private String processLabel(String key, boolean isHtml) {
        String prefix = "";
        String suffix = "";
        if (isHtml) {
            prefix = "<b>";
            suffix = "</b>";
        }
        return prefix + this.messageResolver.message(key, new Object[0]) + ":" + suffix + " ";
    }

    private void sendInternal(boolean threaded, InternetAddress to, Map<String, Object> variables, String subject, String body) {
        String processedSubject = MessageProcessingHelper.processVariables(subject, variables);
        String processedBody = MessageProcessingHelper.processVariables(body, variables);
        if (threaded) {
            this.sendAfterTransactionCommit(processedSubject, null, to, processedBody, true);
        } else {
            this.send(processedSubject, null, to, processedBody, true);
        }
    }

    private class SenderThreads
    extends WorkerThreads<MailParameters> {
        public SenderThreads(String name, int threadCount) {
            super(name, threadCount);
        }

        @Override
        protected void process(MailParameters params) {
            MailHandler.this.doSend(params.subject, params.replyTo, params.to, params.body, params.isHTML, true);
        }
    }

    private class MailParameters {
        private String subject;
        private InternetAddress replyTo;
        private InternetAddress to;
        private String body;
        private boolean isHTML;

        private MailParameters() {
        }
    }
}

