/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.struts.CyclosMessageResources;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.MessageResourcesLoadedListener;
import nl.strohalm.cyclos.utils.conversion.BooleanConverter;
import nl.strohalm.cyclos.utils.conversion.MessageConverter;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public final class MessageHelper {
    private CyclosMessageResources messageResources;
    private MessageResolver messageResolver;

    public void addMessageResourcesLoadedListener(MessageResourcesLoadedListener listener) {
        this.messageResources.addMessagesLoadedListener(listener);
    }

    public String firstErrorMessage(ValidationException e) {
        Object[] args;
        ValidationError error;
        if (e == null || !e.hasErrors()) {
            return "";
        }
        Collection<ValidationError> generalErrors = e.getGeneralErrors();
        if (generalErrors != null && !generalErrors.isEmpty()) {
            error = generalErrors.iterator().next();
            args = error.getArguments().toArray();
        } else {
            Map<String, Collection<ValidationError>> errorsByProperty = e.getErrorsByProperty();
            Map.Entry<String, Collection<ValidationError>> entry = errorsByProperty.entrySet().iterator().next();
            String property = entry.getKey();
            String propertyKey = e.getPropertyKey(property);
            error = entry.getValue().iterator().next();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(StringUtils.isEmpty((String)propertyKey) ? property : this.message(propertyKey, new Object[0]));
            if (error.getArguments() != null && !error.getArguments().isEmpty()) {
                arguments.addAll(error.getArguments());
            }
            args = arguments.toArray();
        }
        return this.message(error.getKey(), args);
    }

    public BooleanConverter getBooleanConverter(ServletContext context) {
        return new BooleanConverter(this.message("global.yes", new Object[0]), this.message("global.no", new Object[0]));
    }

    public String getDatePatternDescription(LocalSettings.DatePattern datePattern) {
        String day = this.message("global.datePattern.day", new Object[0]);
        String month = this.message("global.datePattern.month", new Object[0]);
        String year = this.message("global.datePattern.year", new Object[0]);
        String[] parts = null;
        switch (datePattern) {
            case DD_MM_YYYY_SLASH: 
            case DD_MM_YYYY_PERIOD: 
            case DD_MM_YYYY_DASH: {
                parts = new String[]{day, month, year};
                break;
            }
            case MM_DD_YYYY_SLASH: 
            case MM_DD_YYYY_DASH: 
            case MM_DD_YYYY_PERIOD: {
                parts = new String[]{month, day, year};
                break;
            }
            case YYYY_MM_DD_SLASH: 
            case YYYY_MM_DD_DASH: 
            case YYYY_MM_DD_PERIOD: {
                parts = new String[]{year, month, day};
            }
        }
        return StringUtils.join(parts, (char)datePattern.getSeparator());
    }

    public MessageConverter getMessageConverter(ServletContext context, String prefix) {
        return new MessageConverter(this.messageResolver, prefix);
    }

    public String getTimePatternDescription(LocalSettings.TimePattern timePattern) {
        String hour = this.message("global.datePattern.hour", new Object[0]);
        String minute = this.message("global.datePattern.minute", new Object[0]);
        String second = this.message("global.datePattern.second", new Object[0]);
        String[] parts = null;
        switch (timePattern) {
            case HH12_MM: 
            case HH24_MM: {
                parts = new String[]{hour, minute};
                break;
            }
            case HH12_MM_SS: 
            case HH24_MM_SS: {
                parts = new String[]{hour, minute, second};
            }
        }
        return StringUtils.join(parts, (String)":");
    }

    public String message(String key, List<Object> args) {
        return this.message(key, CollectionUtils.isEmpty(args) ? null : args.toArray());
    }

    public String message(String key, Object ... args) {
        try {
            return this.messageResources.getMessage(key, args);
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setMessageResources(CyclosMessageResources messageResources) {
        this.messageResources = messageResources;
    }
}

