/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountStatus;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class MessageProcessingHelper {
    public static String processDate(String message) {
        return MessageProcessingHelper.processDate(message, null);
    }

    public static String processDate(String message, Calendar date) {
        if (message == null) {
            return "";
        }
        if (date == null) {
            date = Calendar.getInstance();
        }
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        boolean inDate = false;
        StringBuilder datePart = new StringBuilder();
        block4: for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (escape) {
                sb.append(c);
                escape = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block4;
                }
                case '#': {
                    if (inDate) {
                        SimpleDateFormat df = new SimpleDateFormat(datePart.toString());
                        sb.append(df.format(date.getTime()));
                        datePart.setLength(0);
                    }
                    inDate = !inDate;
                    continue block4;
                }
                default: {
                    (inDate ? datePart : sb).append(c);
                }
            }
        }
        if (inDate) {
            sb.append('#').append(datePart.toString());
        }
        return sb.toString();
    }

    public static String processVariables(String message, Entity entity, LocalSettings localSettings) {
        return MessageProcessingHelper.processVariables(message, entity.getVariableValues(localSettings));
    }

    public static String processVariables(String content, LocalSettings localSettings, AccountOwner accountOwner, AccountStatus status, Entity ... entities) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (entities != null) {
            for (Entity entity : entities) {
                if (entity == null) continue;
                values.putAll(entity.getVariableValues(localSettings));
            }
        }
        if (accountOwner != null) {
            values.putAll(accountOwner.getVariableValues(localSettings));
        }
        if (status != null) {
            values.putAll(status.getVariableValues(localSettings));
        }
        return MessageProcessingHelper.processVariables(content, values);
    }

    public static String processVariables(String content, LocalSettings localSettings, AccountOwner accountOwner, Entity ... entities) {
        return MessageProcessingHelper.processVariables(content, localSettings, accountOwner, null, entities);
    }

    public static String processVariables(String message, Map<String, ?> values) {
        if (message == null) {
            return "";
        }
        if (values == null || values.isEmpty()) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder variableName = new StringBuilder();
        boolean escape = false;
        boolean inVariable = false;
        block4: for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (escape) {
                sb.append(c);
                escape = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block4;
                }
                case '#': {
                    if (inVariable) {
                        String name = variableName.toString();
                        Object value = values.get(name);
                        if (value == null) {
                            sb.append('#').append(name).append('#');
                        } else {
                            sb.append(CoercionHelper.coerce(String.class, value));
                        }
                        variableName.setLength(0);
                    }
                    inVariable = !inVariable;
                    continue block4;
                }
                default: {
                    (inVariable ? variableName : sb).append(c);
                }
            }
        }
        if (inVariable) {
            sb.append('#').append(variableName.toString());
        }
        return sb.toString();
    }
}

