/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.Period;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class NamedPeriod
extends Period {
    private static final long serialVersionUID = 474875095971518438L;
    private String name;

    public static int getLastQuarter() {
        Calendar today = Calendar.getInstance();
        return NamedPeriod.getLastQuarter(today);
    }

    public static int getLastQuarter(Calendar cal) {
        int month = cal.get(2);
        int quarter = month / 3 + 1;
        return quarter;
    }

    public static NamedPeriod getLastQuarterPeriod() {
        Calendar today = Calendar.getInstance();
        return NamedPeriod.getQuarterPeriod(today);
    }

    public static NamedPeriod getQuarterPeriod(Calendar aDate) {
        int year = aDate.get(1);
        int quarter = NamedPeriod.getLastQuarter(aDate);
        int endMonth = 3 * quarter - 3;
        GregorianCalendar endDay = new GregorianCalendar(year, endMonth, 1, 0, 0, 0);
        Calendar startDay = (Calendar)((Calendar)endDay).clone();
        if (quarter == 1) {
            startDay.add(1, -1);
            --year;
        } else {
            startDay.add(2, -3);
        }
        ((Calendar)endDay).add(14, -1);
        NamedPeriod period = new NamedPeriod(startDay, endDay, NamedPeriod.produceName(year, quarter));
        return period;
    }

    private static String produceName(int year, int quarter) {
        String name = "";
        for (int i = quarter - 1; i > 0; --i) {
            name = name + "I";
        }
        name = ("" + year + " " + name).trim();
        return name;
    }

    public NamedPeriod() {
    }

    public NamedPeriod(Calendar begin, Calendar end) {
        super(begin, end);
    }

    public NamedPeriod(Calendar begin, Calendar end, String name) {
        this(begin, end);
        this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NamedPeriod)) {
            return false;
        }
        NamedPeriod p = (NamedPeriod)obj;
        return new EqualsBuilder().append((Object)this.getBegin(), (Object)p.getBegin()).append((Object)this.getEnd(), (Object)p.getEnd()).isEquals();
    }

    public String getName() {
        return this.name;
    }

    public NamedPeriod getOneYearEarlier() {
        Calendar beginDate = (Calendar)this.getBegin().clone();
        beginDate.add(1, -1);
        Calendar endDate = (Calendar)this.getEnd().clone();
        endDate.add(1, -1);
        int presentYear = this.getBegin().get(1);
        String newName = this.getName();
        if (this.getName().indexOf(String.valueOf(presentYear)) >= 0) {
            newName = this.getName().replaceAll(String.valueOf(presentYear), String.valueOf(presentYear - 1));
        }
        return new NamedPeriod(beginDate, endDate, newName);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getBegin()).append((Object)this.getEnd()).toHashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return super.toString() + ", name: " + FormatObject.formatObject(this.name, "<null>");
    }
}

