/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.utils.RequestHelper;
import org.apache.struts.action.ActionMapping;

public class Navigation
implements Serializable {
    public static final String NAVIGATION_KEY = "navigation";
    private static final long serialVersionUID = 7518139480217210726L;
    private final LinkedList<ActionMapping> paths = new LinkedList();
    private ActionMapping lastAction;

    public static Navigation get(HttpSession session) {
        if (session == null) {
            return null;
        }
        Navigation navigation = (Navigation)session.getAttribute(NAVIGATION_KEY);
        if (navigation == null) {
            navigation = new Navigation();
            session.setAttribute(NAVIGATION_KEY, (Object)navigation);
        }
        return navigation;
    }

    private Navigation() {
    }

    public String back() {
        if (!this.paths.isEmpty()) {
            ActionMapping last = this.paths.removeFirst();
            if (this.lastAction != null && this.lastAction.getPath().equals(last.getPath())) {
                this.setLastAction(null);
                return this.back();
            }
            return last.getPath();
        }
        return null;
    }

    public void clear() {
        this.paths.clear();
        this.lastAction = null;
    }

    public boolean contains(String path) {
        return this.indexOf(path) >= 0;
    }

    public String getLast() {
        return this.paths.isEmpty() ? null : this.paths.getFirst().getPath();
    }

    public ActionMapping getLastAction() {
        return this.lastAction;
    }

    public String getPrevious() {
        return this.paths.size() < 2 ? null : this.paths.get(1).getPath();
    }

    public int indexOf(String path) {
        int index = -1;
        for (ActionMapping current : this.paths) {
            ++index;
            if (!current.getPath().contains(path)) continue;
            return index;
        }
        return -1;
    }

    public String removeCurrent() {
        if (!this.paths.isEmpty()) {
            return this.paths.removeFirst().getPath();
        }
        return null;
    }

    public void setLastAction(ActionMapping lastAction) {
        this.lastAction = lastAction;
    }

    public int size() {
        return this.paths.size();
    }

    public void store(ActionContext context) {
        ActionMapping last;
        ActionMapping actionMapping = context.getActionMapping();
        if (RequestHelper.isFromMenu(context.getRequest())) {
            this.clear();
        }
        String path = actionMapping.getPath();
        ActionMapping actionMapping2 = last = this.paths.isEmpty() ? null : this.paths.getFirst();
        if (last == null) {
            this.paths.addFirst(actionMapping);
        } else if (!path.equals(last.getPath())) {
            int position = this.indexOf(path) + 1;
            for (int i = 0; i < position; ++i) {
                this.paths.removeFirst();
            }
            this.paths.addFirst(actionMapping);
        }
    }
}

