/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import nl.strohalm.cyclos.utils.WorkerThreads;
import org.apache.commons.lang.mutable.MutableObject;

public abstract class ParallelTask<T> {
    private static final int DEFAULT_MAX_PARALLEL_THREADS = 5;
    private String name;
    private int maxParallelThreads;

    public ParallelTask(String name) {
        this(name, 5);
    }

    public ParallelTask(String name, int maxParallelThreads) {
        this.name = name;
        this.maxParallelThreads = maxParallelThreads;
    }

    public void run(Collection<T> tasks) {
        final CountDownLatch latch = new CountDownLatch(tasks.size());
        final MutableObject exception = new MutableObject();
        WorkerThreads threads = new WorkerThreads<T>(this.name, this.maxParallelThreads, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(T object) {
                try {
                    if (exception.getValue() == null) {
                        ParallelTask.this.process(object);
                    }
                }
                catch (Exception e) {
                    exception.setValue((Object)e);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        threads.enqueueAll(tasks);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            threads.interrupt();
        }
        Exception e = (Exception)exception.getValue();
        if (e != null) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new IllegalStateException(e);
        }
    }

    protected abstract void process(T var1);
}

