/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.Quarter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DateUtils;

public class Period
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6246167529034823152L;
    private Calendar begin;
    private Calendar end;
    private boolean useTime;
    private boolean inclusiveBegin = true;
    private boolean inclusiveEnd = true;

    public static Period begginingAt(Calendar begin) {
        return new Period(begin, null);
    }

    public static Period between(Calendar begin, Calendar end) {
        return new Period(begin, end);
    }

    public static Period betweenOneYear(int year) {
        GregorianCalendar begin = new GregorianCalendar(year, 0, 1);
        GregorianCalendar end = new GregorianCalendar(year, 11, 31, 23, 59, 59);
        return Period.between(begin, end);
    }

    public static Period day(Calendar day) {
        day = DateHelper.truncate(day);
        return new Period(day, day);
    }

    public static Period endingAt(Calendar end) {
        return new Period(null, end);
    }

    public static Period exact(Calendar time) {
        return new Period(time, time);
    }

    public Period() {
    }

    public Period(Calendar begin, Calendar end) {
        this.setBegin(begin);
        this.setEnd(end);
    }

    public Period clone() {
        Period newPeriod;
        try {
            newPeriod = (Period)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
        newPeriod.begin = this.begin == null ? null : (Calendar)this.begin.clone();
        newPeriod.end = this.end == null ? null : (Calendar)this.end.clone();
        return newPeriod;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Period)) {
            return false;
        }
        Period p = (Period)obj;
        return new EqualsBuilder().append((Object)this.begin, (Object)p.begin).append((Object)this.end, (Object)p.end).isEquals();
    }

    public Calendar getBegin() {
        return this.begin;
    }

    public Quarter getBeginQuarter() {
        return this.getQuarter(this.begin);
    }

    public int getDays() {
        if (this.begin == null || this.end == null) {
            return -1;
        }
        return DateHelper.daysBetween(this.begin, this.end);
    }

    public long getDifference() {
        if (this.begin == null || this.end == null) {
            throw new IllegalStateException("Not a complete period: " + this);
        }
        double millis = this.end.getTimeInMillis() - this.begin.getTimeInMillis();
        return (long)Math.ceil(millis / 1000.0);
    }

    public Calendar getEnd() {
        return this.end;
    }

    public Quarter getEndQuarter() {
        return this.getQuarter(this.end);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.begin).append((Object)this.end).toHashCode();
    }

    public boolean includes(Calendar date) {
        if (date == null) {
            return false;
        }
        if (this.begin == null && this.end == null) {
            return true;
        }
        if (this.useTime) {
            boolean beginOK;
            if (this.begin == null) {
                return this.inclusiveEnd ? !this.end.before(date) : date.before(this.end);
            }
            if (this.end == null) {
                return this.inclusiveBegin ? !date.before(this.begin) : this.begin.before(date);
            }
            boolean bl = this.inclusiveBegin ? !date.before(this.begin) : (beginOK = this.begin.before(date));
            boolean endOK = this.inclusiveEnd ? !this.end.before(date) : date.before(this.end);
            return beginOK && endOK;
        }
        Calendar tDate = DateUtils.truncate((Calendar)date, (int)5);
        Calendar tBegin = this.begin;
        Calendar tEnd = this.end;
        if (this.begin != null) {
            tBegin = DateUtils.truncate((Calendar)this.begin, (int)5);
        }
        if (this.end != null) {
            tEnd = DateHelper.truncateNextDay(this.end);
        }
        if (tBegin == null) {
            return tDate.before(tEnd);
        }
        if (tEnd == null) {
            return !tDate.before(tBegin);
        }
        return !tDate.before(tBegin) && tDate.before(tEnd);
    }

    public boolean isInclusiveBegin() {
        return this.inclusiveBegin;
    }

    public boolean isInclusiveEnd() {
        return this.inclusiveEnd;
    }

    public boolean isUseTime() {
        return this.useTime;
    }

    public void setBegin(Calendar begin) {
        this.begin = begin;
    }

    public void setEnd(Calendar end) {
        this.end = end;
    }

    public void setInclusiveBegin(boolean inclusiveBegin) {
        this.inclusiveBegin = inclusiveBegin;
    }

    public void setInclusiveEnd(boolean inclusiveEnd) {
        this.inclusiveEnd = inclusiveEnd;
    }

    public void setUseTime(boolean useTime) {
        this.useTime = useTime;
    }

    public String toString() {
        return "begin: " + FormatObject.formatObject(this.begin, "<null>") + ", end: " + FormatObject.formatObject(this.end, "<null>");
    }

    public Period useTime() {
        this.useTime = true;
        return this;
    }

    private Quarter getQuarter(Calendar cal) {
        int month = cal.get(2);
        int quarter = month / 3;
        return Quarter.getQuarter(++quarter);
    }
}

