/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;

public class PropertiesHelper {
    public static Properties loadFromResource(String baseName) {
        String path = baseName.replace('.', '/');
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream in = loader.getResourceAsStream(path + ".properties");
        if (in == null) {
            return null;
        }
        return PropertiesHelper.loadFromStream(in);
    }

    public static Properties loadFromStream(InputStream in) {
        Properties properties = new Properties();
        try {
            try {
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                MethodUtils.invokeMethod((Object)properties, (String)"load", (Object)reader);
            }
            catch (NoSuchMethodException e) {
                properties.load(in);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading resource bundle", e);
        }
        return properties;
    }

    public static void main(String[] args) {
        ResourceBundle bundle = PropertiesHelper.readBundle("nl.strohalm.cyclos.setup.CyclosSetup", new Locale("pt", "BR", "RS"));
        System.out.println(bundle);
    }

    public static ResourceBundle readBundle(String baseName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList<String> suffixes = new ArrayList<String>();
        if (locale != null) {
            suffixes.add("");
            if (StringUtils.isNotEmpty((String)locale.getLanguage())) {
                suffixes.add("_" + locale.getLanguage());
            }
            if (StringUtils.isNotEmpty((String)locale.getCountry()) && StringUtils.isNotEmpty((String)locale.getLanguage())) {
                suffixes.add("_" + locale.getLanguage() + "_" + locale.getCountry());
            }
            if (StringUtils.isNotEmpty((String)locale.getVariant()) && StringUtils.isNotEmpty((String)locale.getCountry()) && StringUtils.isNotEmpty((String)locale.getLanguage())) {
                suffixes.add("_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant());
            }
        }
        PropertiesResourceBundle bundle = null;
        for (String suffix : suffixes) {
            PropertiesResourceBundle current;
            Properties properties = PropertiesHelper.loadFromResource(baseName + suffix);
            if (properties == null) continue;
            bundle = current = new PropertiesResourceBundle(properties, bundle);
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Error loading properties resource bundle for baseName=" + baseName + " and locale=" + locale);
        }
        return bundle;
    }

    private static class PropertiesResourceBundle
    extends ResourceBundle {
        private Map<String, String> properties;

        private PropertiesResourceBundle(Properties properties, PropertiesResourceBundle parent) {
            this.properties = properties;
            if (parent != null) {
                this.setParent(parent);
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            return IteratorUtils.asEnumeration(this.properties.keySet().iterator());
        }

        @Override
        protected Object handleGetObject(String key) {
            String value = this.properties.get(key);
            return StringUtils.trimToNull((String)value);
        }
    }
}

