/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.beans.PropertyDescriptor;
import nl.strohalm.cyclos.utils.binding.PropertyException;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.NullValueInNestedPathException;

public class PropertyHelper {
    public static void copyProperties(Object source, Object dest, String ... ignored) {
        PropertyDescriptor[] propertyDescriptors;
        if (source == null || dest == null) {
            return;
        }
        for (PropertyDescriptor sourceDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)source)) {
            try {
                PropertyDescriptor destProperty;
                String name = sourceDescriptor.getName();
                if (ArrayUtils.contains((Object[])ignored, (Object)name) || (destProperty = PropertyUtils.getPropertyDescriptor((Object)dest, (String)name)).getWriteMethod() == null) continue;
                Object value = CoercionHelper.coerce(destProperty.getPropertyType(), PropertyHelper.get(source, name));
                PropertyHelper.set(dest, name, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static String firstProperty(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.indexOf(46);
        return pos < 0 ? path : path.substring(0, pos);
    }

    public static <T> T get(Object object, String property) {
        if (object == null) {
            return null;
        }
        if (property == null) {
            return (T)object;
        }
        try {
            return (T)PropertyUtils.getProperty((Object)object, (String)property);
        }
        catch (NestedNullException e) {
            return null;
        }
        catch (NullValueInNestedPathException e) {
            return null;
        }
        catch (Exception e) {
            throw new PropertyException(object, property, e);
        }
    }

    public static <T> T getAsObject(Class<T> toType, String value, Converter<T> converter) {
        if (StringUtils.isEmpty((String)value) && !toType.isPrimitive()) {
            return null;
        }
        String ret = null;
        ret = converter != null ? converter.valueOf(value) : value;
        return CoercionHelper.coerce(toType, ret);
    }

    public static <T> String getAsString(T value, Converter<T> converter) {
        if (value == null) {
            return null;
        }
        String ret = null;
        ret = converter != null ? converter.toString(value) : (String)value;
        return CoercionHelper.coerce(String.class, ret);
    }

    public static String lastProperty(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf(46);
        return pos < 0 ? null : path.substring(pos + 1);
    }

    public static String nestedPath(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.indexOf(46);
        return pos < 0 ? null : path.substring(pos + 1);
    }

    public static String pathUntilLast(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf(46);
        return pos < 0 ? null : path.substring(0, pos);
    }

    public static void set(Object object, String property, Object value) {
        if (object == null) {
            return;
        }
        try {
            PropertyUtils.setProperty((Object)object, (String)property, (Object)value);
        }
        catch (NullValueInNestedPathException e) {
        }
        catch (Exception e) {
            throw new PropertyException(object, property, e);
        }
    }
}

