/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.io.Serializable;
import nl.strohalm.cyclos.utils.validation.MaxLengthError;
import nl.strohalm.cyclos.utils.validation.MinLengthError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RangeConstraint
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7227958658299214274L;
    private Integer max;
    private Integer min;

    public static RangeConstraint between(int min, int max) {
        return new RangeConstraint(min, max);
    }

    public static RangeConstraint fixed(int length) {
        return new RangeConstraint(length, length);
    }

    public static RangeConstraint from(int min) {
        return new RangeConstraint(min, null);
    }

    public static RangeConstraint to(int max) {
        return new RangeConstraint(null, max);
    }

    public RangeConstraint() {
    }

    public RangeConstraint(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public RangeConstraint clone() {
        try {
            return (RangeConstraint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeConstraint)) {
            return false;
        }
        RangeConstraint rc = (RangeConstraint)obj;
        return new EqualsBuilder().append((Object)this.min, (Object)rc.min).append((Object)this.max, (Object)rc.max).isEquals();
    }

    public ValidationError errorFor(int number) {
        if (this.min != null && this.min > 0 && number < this.min) {
            return new MinLengthError(this.min);
        }
        if (this.max != null && this.max > 0 && number > this.max) {
            return new MaxLengthError(this.max);
        }
        return null;
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.min).append((Object)this.max).toHashCode();
    }

    public boolean inRange(int number) {
        if (this.min != null && this.min < number) {
            return false;
        }
        return this.max == null || this.max <= number;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public String toString() {
        return this.min + " - " + this.max;
    }
}

