/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.utils;

import java.util.Arrays;
import java.util.LinkedList;
import nl.strohalm.cyclos.entities.Relationship;
import org.apache.commons.lang.StringUtils;

public final class RelationshipHelper {
    public static Relationship forName(final String name) {
        return new Relationship(){

            public boolean equals(Object obj) {
                return obj == null ? false : this.toString().equals(obj.toString());
            }

            @Override
            public String getName() {
                return name;
            }

            public int hashCode() {
                return this.toString().hashCode();
            }

            public String toString() {
                return name;
            }
        };
    }

    public static Relationship nested(int times, Relationship relationship) {
        if (times <= 0 || times > 9) {
            return null;
        }
        Object[] relationships = new Relationship[times];
        Arrays.fill(relationships, relationship);
        return RelationshipHelper.nested((Relationship[])relationships);
    }

    public static Relationship nested(Relationship ... relationships) {
        LinkedList<String> path = new LinkedList<String>();
        for (Relationship relationship : relationships) {
            path.add(relationship.getName());
        }
        return RelationshipHelper.forName(StringUtils.join(path.iterator(), (char)'.'));
    }
}

